/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.store.raw;

import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.daemon.Serviceable;
import org.apache.derby.iapi.services.locks.CompatibilitySpace;
import org.apache.derby.iapi.services.property.PersistentSet;
import org.apache.derby.iapi.store.access.FileResource;
import org.apache.derby.iapi.store.access.RowSource;
import org.apache.derby.iapi.store.raw.ContainerHandle;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.GlobalTransactionId;
import org.apache.derby.iapi.store.raw.LockingPolicy;
import org.apache.derby.iapi.store.raw.Loggable;
import org.apache.derby.iapi.store.raw.StreamContainerHandle;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.types.DataValueFactory;

public interface Transaction {
    public static final int RELEASE_LOCKS = 1;
    public static final int KEEP_LOCKS = 2;
    public static final int XA_RDONLY = 1;
    public static final int XA_OK = 2;

    public ContextManager getContextManager();

    public CompatibilitySpace getCompatibilitySpace();

    public void setNoLockWait(boolean var1);

    public void setup(PersistentSet var1) throws StandardException;

    public GlobalTransactionId getGlobalId();

    public LockingPolicy getDefaultLockingPolicy();

    public LockingPolicy newLockingPolicy(int var1, int var2, boolean var3);

    public void setDefaultLockingPolicy(LockingPolicy var1);

    public LogInstant commit() throws StandardException;

    public LogInstant commitNoSync(int var1) throws StandardException;

    public void abort() throws StandardException;

    public void close() throws StandardException;

    public void destroy() throws StandardException;

    public int setSavePoint(String var1, Object var2) throws StandardException;

    public int releaseSavePoint(String var1, Object var2) throws StandardException;

    public int rollbackToSavePoint(String var1, Object var2) throws StandardException;

    public ContainerHandle openContainer(ContainerKey var1, int var2) throws StandardException;

    public ContainerHandle openContainer(ContainerKey var1, LockingPolicy var2, int var3) throws StandardException;

    public long addContainer(long var1, long var3, int var5, Properties var6, int var7) throws StandardException;

    public void dropContainer(ContainerKey var1) throws StandardException;

    public long addAndLoadStreamContainer(long var1, Properties var3, RowSource var4) throws StandardException;

    public StreamContainerHandle openStreamContainer(long var1, long var3, boolean var5) throws StandardException;

    public void dropStreamContainer(long var1, long var3) throws StandardException;

    public void logAndDo(Loggable var1) throws StandardException;

    public void addPostCommitWork(Serviceable var1);

    public void addPostTerminationWork(Serviceable var1);

    public boolean isIdle();

    public boolean isPristine();

    public FileResource getFileHandler();

    public boolean anyoneBlocked();

    public void createXATransactionFromLocalTransaction(int var1, byte[] var2, byte[] var3) throws StandardException;

    public void xa_commit(boolean var1) throws StandardException;

    public int xa_prepare() throws StandardException;

    public void xa_rollback() throws StandardException;

    public String getActiveStateTxIdString();

    public DataValueFactory getDataValueFactory() throws StandardException;
}

