/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.output.elasticsearch;

import org.apache.manifoldcf.agents.output.elasticsearch.ElasticSearchParam;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.IPostParameters;

public class ElasticSearchConfig
extends ElasticSearchParam {
    private static final long serialVersionUID = -2071296573398352538L;
    private static final ElasticSearchParam.ParameterEnum[] CONFIGURATIONLIST = new ElasticSearchParam.ParameterEnum[]{ElasticSearchParam.ParameterEnum.SERVERLOCATION, ElasticSearchParam.ParameterEnum.INDEXNAME, ElasticSearchParam.ParameterEnum.INDEXTYPE};

    public ElasticSearchConfig(ConfigParams params) {
        super(CONFIGURATIONLIST);
        for (ElasticSearchParam.ParameterEnum param : CONFIGURATIONLIST) {
            String value = params.getParameter(param.name());
            if (value == null) {
                value = param.defaultValue;
            }
            this.put(param, value);
        }
    }

    public String getUniqueIndexIdentifier() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getServerLocation());
        if (sb.charAt(sb.length() - 1) != '/') {
            sb.append('/');
        }
        sb.append(this.getIndexName());
        return sb.toString();
    }

    public static final void contextToConfig(IPostParameters variableContext, ConfigParams parameters) {
        for (ElasticSearchParam.ParameterEnum param : CONFIGURATIONLIST) {
            String p = variableContext.getParameter(param.name().toLowerCase());
            if (p == null) continue;
            parameters.setParameter(param.name(), p);
        }
    }

    public final String getServerLocation() {
        return (String)this.get((Object)ElasticSearchParam.ParameterEnum.SERVERLOCATION);
    }

    public final String getIndexName() {
        return (String)this.get((Object)ElasticSearchParam.ParameterEnum.INDEXNAME);
    }

    public final String getIndexType() {
        return (String)this.get((Object)ElasticSearchParam.ParameterEnum.INDEXTYPE);
    }
}

