/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.system;

import org.apache.manifoldcf.agents.interfaces.AgentManagerFactory;
import org.apache.manifoldcf.agents.interfaces.IAgentManager;
import org.apache.manifoldcf.agents.interfaces.IIncrementalIngester;
import org.apache.manifoldcf.agents.interfaces.IOutputConnectionManager;
import org.apache.manifoldcf.agents.interfaces.IOutputConnectorManager;
import org.apache.manifoldcf.agents.interfaces.ITransformationConnectionManager;
import org.apache.manifoldcf.agents.interfaces.ITransformationConnectorManager;
import org.apache.manifoldcf.agents.interfaces.IncrementalIngesterFactory;
import org.apache.manifoldcf.agents.interfaces.OutputConnectionManagerFactory;
import org.apache.manifoldcf.agents.interfaces.OutputConnectorManagerFactory;
import org.apache.manifoldcf.agents.interfaces.OutputConnectorPoolFactory;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.agents.interfaces.TransformationConnectionManagerFactory;
import org.apache.manifoldcf.agents.interfaces.TransformationConnectorManagerFactory;
import org.apache.manifoldcf.agents.system.Logging;
import org.apache.manifoldcf.core.interfaces.Configuration;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;

public class ManifoldCF
extends org.apache.manifoldcf.core.system.ManifoldCF {
    public static final String _rcsid = "@(#)$Id: ManifoldCF.java 988245 2010-08-23 18:39:35Z kwright $";
    public static final String agentShutdownSignal = "_AGENTRUN_";
    protected static boolean agentsInitialized = false;
    protected static final String API_ERRORNODE = "error";
    protected static final String API_SERVICEINTERRUPTIONNODE = "service_interruption";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initializeEnvironment(IThreadContext threadContext) throws ManifoldCFException {
        Integer n = initializeFlagLock;
        synchronized (n) {
            org.apache.manifoldcf.core.system.ManifoldCF.initializeEnvironment((IThreadContext)threadContext);
            ManifoldCF.localInitialize(threadContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanUpEnvironment(IThreadContext threadContext) {
        Integer n = initializeFlagLock;
        synchronized (n) {
            ManifoldCF.localCleanup(threadContext);
            org.apache.manifoldcf.core.system.ManifoldCF.cleanUpEnvironment((IThreadContext)threadContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void localInitialize(IThreadContext threadContext) throws ManifoldCFException {
        Integer n = initializeFlagLock;
        synchronized (n) {
            if (agentsInitialized) {
                return;
            }
            Logging.initializeLoggers();
            Logging.setLogLevels((IThreadContext)threadContext);
            agentsInitialized = true;
        }
    }

    public static void localCleanup(IThreadContext threadContext) {
        block2: {
            try {
                OutputConnectorPoolFactory.make(threadContext).closeAllConnectors();
            }
            catch (ManifoldCFException e) {
                if (Logging.agents == null) break block2;
                Logging.agents.warn((Object)("Exception shutting down output connector pool: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetEnvironment(IThreadContext threadContext) {
        Integer n = initializeFlagLock;
        synchronized (n) {
            org.apache.manifoldcf.core.system.ManifoldCF.resetEnvironment((IThreadContext)threadContext);
        }
    }

    public static void installTables(IThreadContext threadcontext) throws ManifoldCFException {
        IAgentManager mgr = AgentManagerFactory.make(threadcontext);
        IIncrementalIngester igstmgr = IncrementalIngesterFactory.make(threadcontext);
        IOutputConnectorManager outputConnMgr = OutputConnectorManagerFactory.make(threadcontext);
        IOutputConnectionManager outputConnectionManager = OutputConnectionManagerFactory.make(threadcontext);
        ITransformationConnectorManager transConnMgr = TransformationConnectorManagerFactory.make(threadcontext);
        ITransformationConnectionManager transConnectionManager = TransformationConnectionManagerFactory.make(threadcontext);
        mgr.install();
        outputConnMgr.install();
        outputConnectionManager.install();
        transConnMgr.install();
        transConnectionManager.install();
        igstmgr.install();
    }

    public static void deinstallTables(IThreadContext threadcontext) throws ManifoldCFException {
        IAgentManager mgr = AgentManagerFactory.make(threadcontext);
        IIncrementalIngester igstmgr = IncrementalIngesterFactory.make(threadcontext);
        IOutputConnectorManager outputConnMgr = OutputConnectorManagerFactory.make(threadcontext);
        IOutputConnectionManager outputConnectionManager = OutputConnectionManagerFactory.make(threadcontext);
        ITransformationConnectorManager transConnMgr = TransformationConnectorManagerFactory.make(threadcontext);
        ITransformationConnectionManager transConnectionManager = TransformationConnectionManagerFactory.make(threadcontext);
        igstmgr.deinstall();
        transConnectionManager.deinstall();
        transConnMgr.deinstall();
        outputConnectionManager.deinstall();
        outputConnMgr.deinstall();
        mgr.deinstall();
    }

    public static void signalOutputConnectionRedo(IThreadContext threadContext, String connectionName) throws ManifoldCFException {
        IIncrementalIngester ingester = IncrementalIngesterFactory.make(threadContext);
        IOutputConnectionManager outputConnectionManager = OutputConnectionManagerFactory.make(threadContext);
        ingester.resetOutputConnection(outputConnectionManager.load(connectionName));
        AgentManagerFactory.noteOutputConnectionChange(threadContext, connectionName);
    }

    public static void signalOutputConnectionRemoved(IThreadContext threadContext, String connectionName) throws ManifoldCFException {
        IIncrementalIngester ingester = IncrementalIngesterFactory.make(threadContext);
        IOutputConnectionManager outputConnectionManager = OutputConnectionManagerFactory.make(threadContext);
        ingester.removeOutputConnection(outputConnectionManager.load(connectionName));
        AgentManagerFactory.noteOutputConnectionChange(threadContext, connectionName);
    }

    public static String qualifyOutputActivityName(String outputActivityName, String outputConnectionName) {
        return outputActivityName + " (" + outputConnectionName + ")";
    }

    public static String qualifyTransformationActivityName(String transformationActivityName, String transformationConnectionName) {
        return transformationActivityName + " [" + transformationConnectionName + "]";
    }

    public static ConfigurationNode findConfigurationNode(Configuration input, String argumentName) {
        int i = 0;
        while (i < input.getChildCount()) {
            ConfigurationNode cn;
            if (!(cn = input.findChild(i++)).getType().equals(argumentName)) continue;
            return cn;
        }
        return null;
    }

    public static String getRootArgument(Configuration input, String argumentName) {
        ConfigurationNode node = ManifoldCF.findConfigurationNode(input, argumentName);
        if (node == null) {
            return null;
        }
        return node.getValue();
    }

    public static void createErrorNode(Configuration output, String errorMessage) throws ManifoldCFException {
        ConfigurationNode error = new ConfigurationNode(API_ERRORNODE);
        error.setValue(errorMessage);
        output.addChild(output.getChildCount(), error);
    }

    public static void createErrorNode(Configuration output, ManifoldCFException e) throws ManifoldCFException {
        if (e.getErrorCode() == 2) {
            throw e;
        }
        Logging.api.error((Object)e.getMessage(), (Throwable)e);
        ManifoldCF.createErrorNode(output, e.getMessage());
    }

    public static void createServiceInterruptionNode(Configuration output, ServiceInterruption e) {
        Logging.api.warn((Object)e.getMessage(), (Throwable)e);
        ConfigurationNode error = new ConfigurationNode(API_SERVICEINTERRUPTIONNODE);
        error.setValue(e.getMessage());
        output.addChild(output.getChildCount(), error);
    }
}

