/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.core.lockmanager;

import java.io.File;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.lockmanager.ExpiredObjectException;
import org.apache.manifoldcf.core.lockmanager.FileLockObjectFactory;
import org.apache.manifoldcf.core.lockmanager.LockGate;
import org.apache.manifoldcf.core.lockmanager.LockObjectFactory;
import org.apache.manifoldcf.core.lockmanager.LockPool;
import org.apache.manifoldcf.core.lockmanager.ZooKeeperBase;
import org.apache.manifoldcf.core.lockmanager.ZooKeeperConnectionPool;
import org.apache.manifoldcf.core.lockmanager.ZooKeeperLockObjectFactory;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestZooKeeperLocks
extends ZooKeeperBase {
    protected File synchDir = null;
    protected static final int readerThreadCount = 10;
    protected static final int writerThreadCount = 5;

    @Test
    public void multiThreadZooKeeperLockTest() throws Exception {
        ZooKeeperConnectionPool pool = new ZooKeeperConnectionPool("localhost:8348", 2000);
        ZooKeeperLockObjectFactory factory = new ZooKeeperLockObjectFactory(pool);
        TestZooKeeperLocks.runTest((LockObjectFactory)factory);
    }

    @Before
    public void createSynchDir() throws Exception {
        this.synchDir = new File("synchdir");
        this.synchDir.mkdir();
    }

    @After
    public void removeSynchDir() throws Exception {
        if (this.synchDir != null) {
            TestZooKeeperLocks.deleteRecursively(this.synchDir);
        }
        this.synchDir = null;
    }

    @Test
    public void multiThreadFileLockTest() throws Exception {
        TestZooKeeperLocks.runTest((LockObjectFactory)new FileLockObjectFactory(this.synchDir));
    }

    protected static void runTest(LockObjectFactory factory) throws Exception {
        Throwable e;
        int i;
        String lockKey = "testkey";
        AtomicInteger ai = new AtomicInteger(0);
        ReaderThread[] readerThreads = new ReaderThread[10];
        for (int i2 = 0; i2 < 10; ++i2) {
            readerThreads[i2] = new ReaderThread(factory, lockKey, ai);
            readerThreads[i2].start();
        }
        WriterThread[] writerThreads = new WriterThread[5];
        for (i = 0; i < 5; ++i) {
            writerThreads[i] = new WriterThread(factory, lockKey, ai);
            writerThreads[i].start();
        }
        for (i = 0; i < 10; ++i) {
            e = readerThreads[i].finishUp();
            if (e == null) continue;
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (!(e instanceof Exception)) continue;
            throw (Exception)e;
        }
        for (i = 0; i < 5; ++i) {
            e = writerThreads[i].finishUp();
            if (e == null) continue;
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (!(e instanceof Exception)) continue;
            throw (Exception)e;
        }
    }

    protected static void enterReadLock(Long threadID, LockGate lo) throws Exception {
        try {
            lo.enterReadLock(threadID);
        }
        catch (ExpiredObjectException e) {
            throw new ManifoldCFException("Unexpected exception: " + e.getMessage(), (Throwable)e);
        }
    }

    protected static void leaveReadLock(LockGate lo) throws Exception {
        try {
            lo.leaveReadLock();
        }
        catch (ExpiredObjectException e) {
            throw new ManifoldCFException("Unexpected exception: " + e.getMessage(), (Throwable)e);
        }
    }

    protected static void enterWriteLock(Long threadID, LockGate lo) throws Exception {
        try {
            lo.enterWriteLock(threadID);
        }
        catch (ExpiredObjectException e) {
            throw new ManifoldCFException("Unexpected exception: " + e.getMessage(), (Throwable)e);
        }
    }

    protected static void leaveWriteLock(LockGate lo) throws Exception {
        try {
            lo.leaveWriteLock();
        }
        catch (ExpiredObjectException e) {
            throw new ManifoldCFException("Unexpected exception: " + e.getMessage(), (Throwable)e);
        }
    }

    protected static class WriterThread
    extends Thread {
        protected final LockObjectFactory factory;
        protected final Object lockKey;
        protected final AtomicInteger ai;
        protected final Long threadID;
        protected Throwable exception = null;

        public WriterThread(LockObjectFactory factory, Object lockKey, AtomicInteger ai) {
            this.setName("writer");
            this.factory = factory;
            this.lockKey = lockKey;
            this.ai = ai;
            this.threadID = Thread.currentThread().getId();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                LockPool lp = new LockPool(this.factory);
                while (this.ai.get() < 10) {
                    Thread.sleep(100L);
                }
                LockGate lo = lp.getObject(this.lockKey);
                TestZooKeeperLocks.enterWriteLock(this.threadID, lo);
                try {
                    if ((this.ai.get() - 10) % 2 == 1) {
                        throw new Exception("More than one writer thread active at the same time!");
                    }
                    this.ai.incrementAndGet();
                    Thread.sleep(50L);
                    this.ai.incrementAndGet();
                    System.out.println("Updated write count");
                }
                finally {
                    TestZooKeeperLocks.leaveWriteLock(lo);
                }
            }
            catch (InterruptedException e) {
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public Throwable finishUp() throws InterruptedException {
            this.join();
            return this.exception;
        }
    }

    protected static class ReaderThread
    extends Thread {
        protected final LockObjectFactory factory;
        protected final Object lockKey;
        protected final AtomicInteger ai;
        protected final Long threadID;
        protected Throwable exception = null;

        public ReaderThread(LockObjectFactory factory, Object lockKey, AtomicInteger ai) {
            this.setName("reader");
            this.factory = factory;
            this.lockKey = lockKey;
            this.ai = ai;
            this.threadID = Thread.currentThread().getId();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                LockPool lp = new LockPool(this.factory);
                System.out.println("Entering read lock");
                LockGate lo = lp.getObject(this.lockKey);
                TestZooKeeperLocks.enterReadLock(this.threadID, lo);
                try {
                    System.out.println(" Read lock entered!");
                    this.ai.incrementAndGet();
                    while (this.ai.get() < 10) {
                        Thread.sleep(10L);
                    }
                }
                finally {
                    System.out.println("Leaving read lock");
                    TestZooKeeperLocks.leaveReadLock(lo);
                    System.out.println(" Left read lock!");
                }
                while (this.ai.get() < 20) {
                    System.out.println("Waiting for all write threads to succeed...");
                    lo = lp.getObject(this.lockKey);
                    TestZooKeeperLocks.enterReadLock(this.threadID, lo);
                    try {
                        if ((this.ai.get() - 10) % 2 == 1) {
                            throw new Exception("Was able to read when write lock in place");
                        }
                    }
                    finally {
                        TestZooKeeperLocks.leaveReadLock(lo);
                    }
                    Thread.sleep(100L);
                }
                System.out.println("Done with reader thread");
            }
            catch (InterruptedException e) {
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public Throwable finishUp() throws InterruptedException {
            this.join();
            return this.exception;
        }
    }
}

