/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.signature;

import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.SignatureProperty;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.utils.IdResolver;
import org.apache.xml.security.utils.SignatureElementProxy;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SignatureProperties
extends SignatureElementProxy {
    public SignatureProperties(Document document) {
        super(document);
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public SignatureProperties(Element element, String string) throws XMLSecurityException {
        super(element, string);
    }

    public int getLength() {
        Element[] elementArray = XMLUtils.selectDsNodes(this._constructionElement, "SignatureProperty");
        return elementArray.length;
    }

    public SignatureProperty item(int n) throws XMLSignatureException {
        try {
            Element element = XMLUtils.selectDsNode(this._constructionElement, "SignatureProperty", n);
            if (element == null) {
                return null;
            }
            return new SignatureProperty(element, this._baseURI);
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new XMLSignatureException("empty", xMLSecurityException);
        }
    }

    public void setId(String string) {
        if (this._state == 0 && string != null) {
            this._constructionElement.setAttributeNS(null, "Id", string);
            IdResolver.registerElementById(this._constructionElement, string);
        }
    }

    public String getId() {
        return this._constructionElement.getAttributeNS(null, "Id");
    }

    public void addSignatureProperty(SignatureProperty signatureProperty) {
        this._constructionElement.appendChild(signatureProperty.getElement());
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public String getBaseLocalName() {
        return "SignatureProperties";
    }
}

