/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.repository;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.manifoldcf.core.database.BaseTable;
import org.apache.manifoldcf.core.interfaces.ClauseDescription;
import org.apache.manifoldcf.core.interfaces.ColumnDescription;
import org.apache.manifoldcf.core.interfaces.IDBInterface;
import org.apache.manifoldcf.core.interfaces.IDFactory;
import org.apache.manifoldcf.core.interfaces.ILockManager;
import org.apache.manifoldcf.core.interfaces.IResultRow;
import org.apache.manifoldcf.core.interfaces.IResultSet;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.IndexDescription;
import org.apache.manifoldcf.core.interfaces.LockManagerFactory;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.UnitaryClause;
import org.apache.manifoldcf.crawler.interfaces.BucketDescription;
import org.apache.manifoldcf.crawler.interfaces.FilterCriteria;
import org.apache.manifoldcf.crawler.interfaces.RegExpCriteria;
import org.apache.manifoldcf.crawler.interfaces.SortOrder;

public class RepositoryHistoryManager
extends BaseTable {
    public static final String _rcsid = "@(#)$Id: RepositoryHistoryManager.java 999670 2010-09-21 22:18:19Z kwright $";
    protected static final String idField = "id";
    protected static final String ownerNameField = "owner";
    protected static final String startTimeField = "starttime";
    protected static final String endTimeField = "endtime";
    protected static final String dataSizeField = "datasize";
    protected static final String activityTypeField = "activitytype";
    protected static final String entityIdentifierField = "entityid";
    protected static final String resultCodeField = "resultcode";
    protected static final String resultDescriptionField = "resultdesc";
    protected IThreadContext threadContext;
    protected final ILockManager lockManager;

    public RepositoryHistoryManager(IThreadContext tc, IDBInterface database) throws ManifoldCFException {
        super(database, "repohistory");
        this.threadContext = tc;
        this.lockManager = LockManagerFactory.make((IThreadContext)tc);
    }

    public void install(String parentTable, String parentField) throws ManifoldCFException {
        block11: {
            Map existing = this.getTableSchema(null, null);
            if (existing == null) {
                HashMap<String, ColumnDescription> map = new HashMap<String, ColumnDescription>();
                map.put(ownerNameField, new ColumnDescription("VARCHAR(32)", false, false, parentTable, parentField, false));
                map.put(idField, new ColumnDescription("BIGINT", true, false, null, null, false));
                map.put(startTimeField, new ColumnDescription("BIGINT", false, false, null, null, false));
                map.put(endTimeField, new ColumnDescription("BIGINT", false, false, null, null, false));
                map.put(dataSizeField, new ColumnDescription("BIGINT", false, false, null, null, false));
                map.put(activityTypeField, new ColumnDescription("VARCHAR(64)", false, false, null, null, false));
                map.put(entityIdentifierField, new ColumnDescription("LONGTEXT", false, false, null, null, false));
                map.put(resultCodeField, new ColumnDescription("VARCHAR(255)", false, true, null, null, false));
                map.put(resultDescriptionField, new ColumnDescription("LONGTEXT", false, true, null, null, false));
                this.performCreate(map, null);
            } else {
                ColumnDescription cd = (ColumnDescription)existing.get(activityTypeField);
                if (cd.getTypeString().toUpperCase().equals("VARCHAR(32)")) {
                    HashMap<String, ColumnDescription> alterMap = new HashMap<String, ColumnDescription>();
                    alterMap.put(activityTypeField, new ColumnDescription("VARCHAR(64)", false, false, null, null, false));
                    this.performAlter(null, alterMap, null, null);
                }
            }
            IndexDescription ownerIndex = new IndexDescription(false, new String[]{ownerNameField});
            IndexDescription startTimeIndex = new IndexDescription(false, new String[]{startTimeField});
            IndexDescription endTimeIndex = new IndexDescription(false, new String[]{endTimeField});
            IndexDescription activityTypeIndex = new IndexDescription(false, new String[]{activityTypeField});
            Map indexes = this.getTableIndexes(null, null);
            for (String indexName : indexes.keySet()) {
                IndexDescription id = (IndexDescription)indexes.get(indexName);
                if (ownerIndex != null && id.equals((Object)ownerIndex)) {
                    ownerIndex = null;
                    continue;
                }
                if (startTimeIndex != null && id.equals((Object)startTimeIndex)) {
                    startTimeIndex = null;
                    continue;
                }
                if (endTimeIndex != null && id.equals((Object)endTimeIndex)) {
                    endTimeIndex = null;
                    continue;
                }
                if (activityTypeIndex == null && id.equals((Object)activityTypeIndex)) {
                    activityTypeIndex = null;
                    continue;
                }
                if (indexName.indexOf("_pkey") != -1) continue;
                this.performRemoveIndex(indexName);
            }
            if (ownerIndex != null) {
                this.performAddIndex(null, ownerIndex);
            }
            if (startTimeIndex != null) {
                this.performAddIndex(null, startTimeIndex);
            }
            if (endTimeIndex != null) {
                this.performAddIndex(null, endTimeIndex);
            }
            if (activityTypeIndex == null) break block11;
            this.performAddIndex(null, activityTypeIndex);
        }
    }

    public void deinstall() throws ManifoldCFException {
        this.performDrop(null);
    }

    public void deleteOwner(String owner) throws ManifoldCFException {
        ArrayList params = new ArrayList();
        String query = this.buildConjunctionClause(params, new ClauseDescription[]{new UnitaryClause(ownerNameField, (Object)owner)});
        this.performDelete("WHERE " + query, params, null);
    }

    public void deleteOldRows(long timeCutoff) throws ManifoldCFException {
        ArrayList params = new ArrayList();
        String query = this.buildConjunctionClause(params, new ClauseDescription[]{new UnitaryClause(startTimeField, "<", (Object)new Long(timeCutoff))});
        this.performDelete("WHERE " + query, params, null);
    }

    public Long addRow(String connectionName, long startTime, long endTime, long dataSize, String activityType, String entityIdentifier, String resultCode, String resultDescription) throws ManifoldCFException {
        Long id = new Long(IDFactory.make((IThreadContext)this.threadContext));
        if (this.lockManager.getSharedConfiguration().getBooleanProperty("org.apache.manifoldcf.crawler.repository.store_history", true)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(idField, id);
            map.put(ownerNameField, connectionName);
            map.put(startTimeField, new Long(startTime));
            map.put(endTimeField, new Long(endTime));
            map.put(dataSizeField, new Long(dataSize));
            map.put(activityTypeField, activityType);
            map.put(entityIdentifierField, entityIdentifier);
            if (resultCode != null) {
                map.put(resultCodeField, resultCode);
            }
            if (resultDescription != null) {
                map.put(resultDescriptionField, resultDescription);
            }
            this.performInsert(map, null);
            this.noteModifications(1, 0, 0);
        }
        return id;
    }

    public IResultSet simpleReport(String connectionName, FilterCriteria criteria, SortOrder sort, int startRow, int maxRowCount) throws ManifoldCFException {
        StringBuilder sb = new StringBuilder("SELECT ");
        ArrayList list = new ArrayList();
        sb.append(idField).append(" AS id,").append(activityTypeField).append(" AS activity,").append(startTimeField).append(" AS starttime,(").append(endTimeField).append("-").append(startTimeField).append(")").append(" AS elapsedtime,").append(resultCodeField).append(" AS resultcode,").append(resultDescriptionField).append(" AS resultdesc,").append(dataSizeField).append(" AS bytes,").append(entityIdentifierField).append(" AS identifier FROM ").append(this.getTableName());
        this.addCriteria(sb, list, "", connectionName, criteria, false);
        this.addOrdering(sb, new String[]{startTimeField, idField}, sort);
        this.addLimits(sb, startRow, maxRowCount);
        return this.performQuery(sb.toString(), list, null, null, maxRowCount);
    }

    public long countHistoryRows(String connectionName, FilterCriteria criteria) throws ManifoldCFException {
        StringBuilder sb = new StringBuilder("SELECT ");
        ArrayList list = new ArrayList();
        sb.append(this.constructCountClause("*")).append(" AS countcol FROM ");
        sb.append(this.getTableName());
        this.addCriteria(sb, list, "", connectionName, criteria, false);
        IResultSet set = this.performQuery(sb.toString(), list, null, null);
        if (set.getRowCount() < 1) {
            throw new ManifoldCFException("Expected at least one row");
        }
        IResultRow row = set.getRow(0);
        Long value = (Long)row.getValue("countcol");
        return value;
    }

    public long getMaxRows() throws ManifoldCFException {
        return this.getWindowedReportMaxRows();
    }

    public IResultSet maxActivityCountReport(String connectionName, FilterCriteria filterCriteria, SortOrder sort, BucketDescription idBucket, long interval, int startRow, int maxRowCount) throws ManifoldCFException {
        StringBuilder sb = new StringBuilder();
        ArrayList list = new ArrayList();
        sb.append("SELECT * FROM (SELECT t6.bucket AS bucket,").append("t6.windowstart AS windowstart,t6.windowend AS windowend, SUM(t6.activitycount) AS activitycount").append(" FROM (SELECT ");
        String intervalString = new Long(interval).toString();
        sb.append("t0.bucket AS bucket, t0.").append(startTimeField).append(" AS windowstart, t0.").append(startTimeField).append("+").append(intervalString).append(" AS windowend, ").append(this.constructDoubleCastClause("((CASE WHEN t0.starttime+" + intervalString + "<t1." + endTimeField + " THEN t0." + startTimeField + "+" + intervalString + " ELSE t1." + endTimeField + " END) - (CASE WHEN t0." + startTimeField + ">t1." + startTimeField + " THEN t0." + startTimeField + " ELSE t1." + startTimeField + " END))")).append(" / ").append(this.constructDoubleCastClause("(t1.endtime-t1.starttime)")).append(" AS activitycount FROM (SELECT DISTINCT ");
        this.addBucketExtract(sb, list, "", entityIdentifierField, idBucket);
        sb.append(" AS bucket,").append(startTimeField).append(" FROM ").append(this.getTableName());
        this.addCriteria(sb, list, "", connectionName, filterCriteria, false);
        sb.append(") t0,").append(this.getTableName()).append(" t1 WHERE ");
        sb.append("t0.bucket=");
        this.addBucketExtract(sb, list, "t1.", entityIdentifierField, idBucket);
        sb.append(" AND t1.").append(startTimeField).append("<t0.").append(startTimeField).append("+").append(intervalString).append(" AND t1.").append(endTimeField).append(">t0.").append(startTimeField);
        this.addCriteria(sb, list, "t1.", connectionName, filterCriteria, true);
        sb.append(") t6 GROUP BY bucket,windowstart,windowend UNION SELECT t6a.bucket AS bucket,").append("t6a.windowstart AS windowstart, t6a.windowend AS windowend, SUM(t6a.activitycount) AS activitycount").append(" FROM (SELECT ");
        sb.append("t0a.bucket AS bucket, t0a.").append(endTimeField).append("-").append(intervalString).append(" AS windowstart, t0a.").append(endTimeField).append(" AS windowend, ").append(this.constructDoubleCastClause("((CASE WHEN t0a.endtime<t1a.endtime THEN t0a.endtime ELSE t1a.endtime END) - (CASE WHEN t0a.endtime-" + intervalString + ">t1a." + startTimeField + " THEN t0a." + endTimeField + "-" + intervalString + " ELSE t1a." + startTimeField + " END))")).append(" / ").append(this.constructDoubleCastClause("(t1a.endtime-t1a.starttime)")).append(" AS activitycount FROM (SELECT DISTINCT ");
        this.addBucketExtract(sb, list, "", entityIdentifierField, idBucket);
        sb.append(" AS bucket,").append(endTimeField).append(" FROM ").append(this.getTableName());
        this.addCriteria(sb, list, "", connectionName, filterCriteria, false);
        sb.append(") t0a,").append(this.getTableName()).append(" t1a WHERE ");
        sb.append("t0a.bucket=");
        this.addBucketExtract(sb, list, "t1a.", entityIdentifierField, idBucket);
        sb.append(" AND t1a.").append(startTimeField).append("<t0a.").append(endTimeField).append(" AND t1a.").append(endTimeField).append(">t0a.").append(endTimeField).append("-").append(intervalString);
        this.addCriteria(sb, list, "t1a.", connectionName, filterCriteria, true);
        sb.append(") t6a GROUP BY bucket,windowstart,windowend) t2");
        HashMap<String, String> otherColumns = new HashMap<String, String>();
        otherColumns.put("idbucket", "bucket");
        otherColumns.put("activitycount", "activitycount");
        otherColumns.put(startTimeField, "windowstart");
        otherColumns.put(endTimeField, "windowend");
        StringBuilder newsb = new StringBuilder("SELECT * FROM (");
        ArrayList newList = new ArrayList();
        newsb.append(this.constructDistinctOnClause(newList, sb.toString(), list, new String[]{"idbucket"}, new String[]{"activitycount"}, new boolean[]{false}, otherColumns)).append(") t4");
        this.addOrdering(newsb, new String[]{"activitycount", startTimeField, endTimeField, "idbucket"}, sort);
        this.addLimits(newsb, startRow, maxRowCount);
        return this.performQuery(newsb.toString(), newList, null, null, maxRowCount);
    }

    public IResultSet maxByteCountReport(String connectionName, FilterCriteria filterCriteria, SortOrder sort, BucketDescription idBucket, long interval, int startRow, int maxRowCount) throws ManifoldCFException {
        StringBuilder sb = new StringBuilder();
        ArrayList list = new ArrayList();
        sb.append("SELECT * FROM (SELECT t6.bucket AS bucket,").append("t6.windowstart AS windowstart, t6.windowend AS windowend, SUM(t6.bytecount) AS bytecount").append(" FROM (SELECT ");
        String intervalString = new Long(interval).toString();
        sb.append("t0.bucket AS bucket, t0.").append(startTimeField).append(" AS windowstart, t0.").append(startTimeField).append("+").append(intervalString).append(" AS windowend, ").append("t1.").append(dataSizeField).append(" * ((CASE WHEN t0.").append(startTimeField).append("+").append(intervalString).append("<t1.").append(endTimeField).append(" THEN t0.").append(startTimeField).append("+").append(intervalString).append(" ELSE t1.").append(endTimeField).append(" END) - (CASE WHEN t0.").append(startTimeField).append(">t1.").append(startTimeField).append(" THEN t0.").append(startTimeField).append(" ELSE t1.").append(startTimeField).append(" END)) / (t1.").append(endTimeField).append("-t1.").append(startTimeField).append(")").append(" AS bytecount FROM (SELECT DISTINCT ");
        this.addBucketExtract(sb, list, "", entityIdentifierField, idBucket);
        sb.append(" AS bucket,").append(startTimeField).append(" FROM ").append(this.getTableName());
        this.addCriteria(sb, list, "", connectionName, filterCriteria, false);
        sb.append(") t0,").append(this.getTableName()).append(" t1 WHERE ");
        sb.append("t0.bucket=");
        this.addBucketExtract(sb, list, "t1.", entityIdentifierField, idBucket);
        sb.append(" AND t1.").append(startTimeField).append("<t0.").append(startTimeField).append("+").append(intervalString).append(" AND t1.").append(endTimeField).append(">t0.").append(startTimeField);
        this.addCriteria(sb, list, "t1.", connectionName, filterCriteria, true);
        sb.append(") t6 GROUP BY bucket,windowstart,windowend UNION SELECT t6a.bucket AS bucket,").append("t6a.windowstart AS windowstart, t6a.windowend AS windowend, SUM(t6a.bytecount) AS bytecount").append(" FROM (SELECT ").append("t0a.bucket AS bucket, t0a.").append(endTimeField).append("-").append(intervalString).append(" AS windowstart, t0a.").append(endTimeField).append(" AS windowend, ").append("t1a.").append(dataSizeField).append(" * ((CASE WHEN t0a.").append(endTimeField).append("<t1a.").append(endTimeField).append(" THEN t0a.").append(endTimeField).append(" ELSE t1a.").append(endTimeField).append(" END) - (CASE WHEN t0a.").append(endTimeField).append("-").append(intervalString).append(">t1a.").append(startTimeField).append(" THEN t0a.").append(endTimeField).append("-").append(intervalString).append(" ELSE t1a.").append(startTimeField).append(" END)) / (t1a.").append(endTimeField).append("-t1a.").append(startTimeField).append(")").append(" AS bytecount FROM (SELECT DISTINCT ");
        this.addBucketExtract(sb, list, "", entityIdentifierField, idBucket);
        sb.append(" AS bucket,").append(endTimeField).append(" FROM ").append(this.getTableName());
        this.addCriteria(sb, list, "", connectionName, filterCriteria, false);
        sb.append(") t0a,").append(this.getTableName()).append(" t1a WHERE ");
        sb.append("t0a.bucket=");
        this.addBucketExtract(sb, list, "t1a.", entityIdentifierField, idBucket);
        sb.append(" AND t1a.").append(startTimeField).append("<t0a.").append(endTimeField).append(" AND t1a.").append(endTimeField).append(">t0a.").append(endTimeField).append("-").append(intervalString);
        this.addCriteria(sb, list, "t1a.", connectionName, filterCriteria, true);
        sb.append(") t6a GROUP BY bucket,windowstart,windowend) t2");
        HashMap<String, String> otherColumns = new HashMap<String, String>();
        otherColumns.put("idbucket", "bucket");
        otherColumns.put("bytecount", "bytecount");
        otherColumns.put(startTimeField, "windowstart");
        otherColumns.put(endTimeField, "windowend");
        StringBuilder newsb = new StringBuilder("SELECT * FROM (");
        ArrayList newList = new ArrayList();
        newsb.append(this.constructDistinctOnClause(newList, sb.toString(), list, new String[]{"idbucket"}, new String[]{"bytecount"}, new boolean[]{false}, otherColumns)).append(") t4");
        this.addOrdering(newsb, new String[]{"bytecount", startTimeField, endTimeField, "idbucket"}, sort);
        this.addLimits(newsb, startRow, maxRowCount);
        return this.performQuery(newsb.toString(), newList, null, null, maxRowCount);
    }

    public IResultSet resultCodesReport(String connectionName, FilterCriteria filterCriteria, SortOrder sort, BucketDescription resultCodeBucket, BucketDescription idBucket, int startRow, int maxRowCount) throws ManifoldCFException {
        StringBuilder sb = new StringBuilder("SELECT t1.resultcodebucket,t1.idbucket,");
        ArrayList list = new ArrayList();
        sb.append(this.constructCountClause("'x'")).append(" AS eventcount FROM (SELECT ");
        this.addBucketExtract(sb, list, "", resultCodeField, resultCodeBucket);
        sb.append(" AS resultcodebucket, ");
        this.addBucketExtract(sb, list, "", entityIdentifierField, idBucket);
        sb.append(" AS idbucket FROM ").append(this.getTableName());
        this.addCriteria(sb, list, "", connectionName, filterCriteria, false);
        sb.append(") t1 GROUP BY resultcodebucket,idbucket");
        this.addOrdering(sb, new String[]{"eventcount", "resultcodebucket", "idbucket"}, sort);
        this.addLimits(sb, startRow, maxRowCount);
        return this.performQuery(sb.toString(), list, null, null, maxRowCount);
    }

    protected void addBucketExtract(StringBuilder sb, ArrayList list, String columnPrefix, String columnName, BucketDescription bucketDesc) {
        boolean isSensitive = bucketDesc.isSensitive();
        sb.append(this.constructSubstringClause(columnPrefix + columnName, "?", !isSensitive));
        list.add(bucketDesc.getRegexp());
    }

    protected boolean addCriteria(StringBuilder sb, ArrayList list, String fieldPrefix, String connectionName, FilterCriteria criteria, boolean whereEmitted) {
        RegExpCriteria resultCodeMatch;
        RegExpCriteria entityMatch;
        Long endTime;
        Long startTime;
        whereEmitted = this.emitClauseStart(sb, whereEmitted);
        sb.append(fieldPrefix).append(ownerNameField).append("=?");
        list.add(connectionName);
        String[] activities = criteria.getActivities();
        if (activities != null) {
            whereEmitted = this.emitClauseStart(sb, whereEmitted);
            if (activities.length == 0) {
                sb.append("0>1");
            } else {
                sb.append(fieldPrefix).append(activityTypeField).append(" IN(");
                int i = 0;
                while (i < activities.length) {
                    if (i > 0) {
                        sb.append(",");
                    }
                    String activity = activities[i++];
                    sb.append("?");
                    list.add(activity);
                }
                sb.append(")");
            }
        }
        if ((startTime = criteria.getStartTime()) != null) {
            whereEmitted = this.emitClauseStart(sb, whereEmitted);
            sb.append(fieldPrefix).append(startTimeField).append(">").append(startTime.toString());
        }
        if ((endTime = criteria.getEndTime()) != null) {
            whereEmitted = this.emitClauseStart(sb, whereEmitted);
            sb.append(fieldPrefix).append(endTimeField).append("<=").append(endTime.toString());
        }
        if ((entityMatch = criteria.getEntityMatch()) != null) {
            whereEmitted = this.emitClauseStart(sb, whereEmitted);
            sb.append(this.constructRegexpClause(fieldPrefix + entityIdentifierField, "?", entityMatch.isInsensitive()));
            list.add(entityMatch.getRegexpString());
        }
        if ((resultCodeMatch = criteria.getResultCodeMatch()) != null) {
            whereEmitted = this.emitClauseStart(sb, whereEmitted);
            sb.append(this.constructRegexpClause(fieldPrefix + resultCodeField, "?", resultCodeMatch.isInsensitive()));
            list.add(resultCodeMatch.getRegexpString());
        }
        return whereEmitted;
    }

    protected boolean emitClauseStart(StringBuilder sb, boolean whereEmitted) {
        if (whereEmitted) {
            sb.append(" AND ");
        } else {
            sb.append(" WHERE ");
        }
        return true;
    }

    protected void addOrdering(StringBuilder sb, String[] completeFieldList, SortOrder sort) {
        int i;
        HashMap<String, String> hash = new HashMap<String, String>();
        sb.append(" ORDER BY ");
        int count = sort.getCount();
        for (i = 0; i < count; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            String column = sort.getColumn(i);
            sb.append(column);
            if (sort.getDirection(i) == 0) {
                sb.append(" ASC");
            } else {
                sb.append(" DESC");
            }
            hash.put(column, column);
        }
        for (int j = 0; j < completeFieldList.length; ++j) {
            String field = completeFieldList[j];
            if (hash.get(field) != null) continue;
            if (i > 0) {
                sb.append(",");
            }
            sb.append(field);
            sb.append(" DESC");
            ++i;
        }
    }

    protected void addLimits(StringBuilder sb, int startRow, int maxRowCount) {
        sb.append(" ").append(this.constructOffsetLimitClause(startRow, maxRowCount));
    }
}

