/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.system;

import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.ThreadContextFactory;
import org.apache.manifoldcf.crawler.interfaces.IJobDescription;
import org.apache.manifoldcf.crawler.interfaces.IJobManager;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnection;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnectionManager;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnector;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnectorPool;
import org.apache.manifoldcf.crawler.interfaces.IReprioritizationTracker;
import org.apache.manifoldcf.crawler.interfaces.JobManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.JobSeedingRecord;
import org.apache.manifoldcf.crawler.interfaces.RepositoryConnectionManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.RepositoryConnectorPoolFactory;
import org.apache.manifoldcf.crawler.interfaces.ReprioritizationTrackerFactory;
import org.apache.manifoldcf.crawler.system.Logging;
import org.apache.manifoldcf.crawler.system.ManifoldCF;
import org.apache.manifoldcf.crawler.system.SeedingActivity;
import org.apache.manifoldcf.crawler.system.SeedingResetManager;

public class SeedingThread
extends Thread {
    public static final String _rcsid = "@(#)$Id: SeedingThread.java 988245 2010-08-23 18:39:35Z kwright $";
    protected final SeedingResetManager resetManager;
    protected final String processID;
    protected static final int MAX_COUNT = 100;

    public SeedingThread(SeedingResetManager resetManager, String processID) throws ManifoldCFException {
        this.setName("Seeding thread");
        this.setDaemon(true);
        this.resetManager = resetManager;
        this.processID = processID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.resetManager.registerMe();
        try {
            IThreadContext threadContext = ThreadContextFactory.make();
            IJobManager jobManager = JobManagerFactory.make(threadContext);
            IRepositoryConnectionManager connectionMgr = RepositoryConnectionManagerFactory.make(threadContext);
            IReprioritizationTracker rt = ReprioritizationTrackerFactory.make(threadContext);
            IRepositoryConnectorPool repositoryConnectorPool = RepositoryConnectorPoolFactory.make(threadContext);
            String[] identifiers = new String[100];
            while (true) {
                try {
                    while (true) {
                        this.resetManager.waitForReset(threadContext);
                        long currentTime = System.currentTimeMillis();
                        long waitTime = 60000L;
                        Logging.threads.debug((Object)"Seeding thread woke up");
                        JobSeedingRecord[] seedJobs = jobManager.getJobsReadyForSeeding(this.processID, currentTime);
                        try {
                            if (seedJobs.length == 0) {
                                Logging.threads.debug((Object)"Seeding thread found nothing to do");
                                ManifoldCF.sleep((long)waitTime);
                                continue;
                            }
                            if (Logging.threads.isDebugEnabled()) {
                                Logging.threads.debug((Object)("Seeding thread: Found " + Integer.toString(seedJobs.length) + " jobs to seed"));
                            }
                            int i = 0;
                            while (i < seedJobs.length) {
                                JobSeedingRecord jsr = seedJobs[i++];
                                Long jobID = jsr.getJobID();
                                try {
                                    String lastSeedingVersion = jsr.getSeedingVersionString();
                                    IJobDescription jobDescription = jobManager.load(jobID, true);
                                    int jobType = jobDescription.getType();
                                    int hopcountMethod = jobDescription.getHopcountMode();
                                    IRepositoryConnection connection = connectionMgr.load(jobDescription.getConnectionName());
                                    IRepositoryConnector connector = repositoryConnectorPool.grab(connection);
                                    if (connector == null) continue;
                                    String newSeedingVersion = null;
                                    try {
                                        String[] legalLinkTypes = connector.getRelationshipTypes();
                                        int model = connector.getConnectorModel();
                                        try {
                                            SeedingActivity activity = new SeedingActivity(connection.getName(), connectionMgr, jobManager, rt, connection, connector, jobID, legalLinkTypes, false, hopcountMethod, this.processID);
                                            if (Logging.threads.isDebugEnabled()) {
                                                Logging.threads.debug((Object)("Seeding thread: Getting seeds for job " + jobID.toString()));
                                            }
                                            newSeedingVersion = connector.addSeedDocuments(activity, jobDescription.getSpecification(), lastSeedingVersion, currentTime, jobType);
                                            activity.doneSeeding(model == 4);
                                            if (Logging.threads.isDebugEnabled()) {
                                                Logging.threads.debug((Object)("Seeding thread: Done processing seeds from job " + jobID.toString()));
                                            }
                                        }
                                        catch (ServiceInterruption e) {
                                            if (!e.jobInactiveAbort()) {
                                                Logging.jobs.warn((Object)("Seeding service interruption reported for job " + jobID + " connection '" + connection.getName() + "': " + e.getMessage()), (Throwable)e);
                                            }
                                            if (!e.jobInactiveAbort() && (jsr.getFailTime() != -1L && jsr.getFailTime() < e.getRetryTime() || jsr.getFailRetryCount() == 0)) {
                                                if (e.isAbortOnFail()) {
                                                    String message;
                                                    String string = e.jobInactiveAbort() ? "" : (message = "Repeated service interruptions during seeding" + (e.getCause() != null ? ": " + e.getCause().getMessage() : ""));
                                                    if (jobManager.errorAbort(jobID, message) && message.length() > 0) {
                                                        Logging.jobs.error((Object)message, e.getCause());
                                                    }
                                                    jsr.noteStarted();
                                                } else {
                                                    jobManager.noteJobSeeded(jobID, newSeedingVersion);
                                                    jsr.noteStarted();
                                                }
                                            } else {
                                                jobManager.retrySeeding(jsr, e.getFailTime(), e.getFailRetryCount());
                                                jsr.noteStarted();
                                            }
                                            repositoryConnectorPool.release(connection, connector);
                                            continue;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        repositoryConnectorPool.release(connection, connector);
                                        throw throwable;
                                    }
                                    repositoryConnectorPool.release(connection, connector);
                                    if (Logging.threads.isDebugEnabled()) {
                                        Logging.threads.debug((Object)("Seeding thread: Successfully reseeded job " + jobID.toString()));
                                    }
                                    jobManager.noteJobSeeded(jobID, newSeedingVersion);
                                    jsr.noteStarted();
                                }
                                catch (ManifoldCFException e) {
                                    if (e.getErrorCode() == 2) {
                                        throw new InterruptedException();
                                    }
                                    if (e.getErrorCode() == 4) {
                                        throw e;
                                    }
                                    if (jobManager.errorAbort(jobID, e.getMessage())) {
                                        Logging.threads.error((Object)("Exception tossed: " + e.getMessage()), (Throwable)e);
                                    }
                                    jsr.noteStarted();
                                }
                            }
                        }
                        finally {
                            ManifoldCFException exception = null;
                            int i = 0;
                            while (i < seedJobs.length) {
                                JobSeedingRecord jsr;
                                if ((jsr = seedJobs[i++]).wasStarted()) continue;
                                if (Logging.threads.isDebugEnabled()) {
                                    Logging.threads.debug((Object)("Seeding thread: aborting reseed for " + jsr.getJobID().toString()));
                                }
                                try {
                                    jobManager.resetSeedJob(jsr.getJobID());
                                }
                                catch (ManifoldCFException e) {
                                    if (e.getErrorCode() == 2) {
                                        throw e;
                                    }
                                    exception = e;
                                }
                            }
                            if (exception == null) continue;
                            throw exception;
                        }
                        ManifoldCF.sleep((long)waitTime);
                    }
                }
                catch (ManifoldCFException e) {
                    if (e.getErrorCode() == 2) break;
                    if (e.getErrorCode() == 4) {
                        this.resetManager.noteEvent();
                        Logging.threads.error((Object)("Seeding thread aborting and restarting due to database connection reset: " + e.getMessage()), (Throwable)e);
                        try {
                            ManifoldCF.sleep((long)10000L);
                            continue;
                        }
                        catch (InterruptedException se) {
                            break;
                        }
                    }
                    Logging.threads.error((Object)("Exception tossed: " + e.getMessage()), (Throwable)e);
                    if (e.getErrorCode() != 3) continue;
                    System.exit(1);
                    continue;
                }
                catch (InterruptedException e) {
                }
                catch (OutOfMemoryError e) {
                    System.err.println("agents process ran out of memory - shutting down");
                    e.printStackTrace(System.err);
                    System.exit(-200);
                    continue;
                }
                catch (Throwable e) {
                    Logging.threads.fatal((Object)("Error tossed: " + e.getMessage()), e);
                    continue;
                }
                break;
            }
        }
        catch (Throwable e) {
            System.err.println("agents process could not start - shutting down");
            Logging.threads.fatal((Object)("SeedingThread initialization error tossed: " + e.getMessage()), e);
            System.exit(-300);
        }
    }
}

