/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.BatchedRemoteIterator;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.EncryptionZone;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class EncryptionZoneIterator
extends BatchedRemoteIterator<Long, EncryptionZone> {
    private final ClientProtocol namenode;

    public EncryptionZoneIterator(ClientProtocol namenode) {
        super((Object)0L);
        this.namenode = namenode;
    }

    public BatchedRemoteIterator.BatchedEntries<EncryptionZone> makeRequest(Long prevId) throws IOException {
        return this.namenode.listEncryptionZones(prevId);
    }

    public Long elementToPrevKey(EncryptionZone entry) {
        return entry.getId();
    }
}

