/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;

public class ProxySettings {
    public static final ProxySettings NO_PROXY = new ProxySettings(null, 0);
    private final String host;
    private final int port;

    public ProxySettings(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public static ProxySettings fromString(String config) {
        Iterable parts = Splitter.on((String)":").split((CharSequence)config);
        String host = (String)Iterables.getFirst((Iterable)parts, (Object)"");
        Preconditions.checkArgument((!host.isEmpty() ? 1 : 0) != 0, (Object)"Host part of proxy must be specified");
        int port = Integer.valueOf((String)Iterables.get((Iterable)parts, (int)1, (Object)"80"));
        return new ProxySettings(host, port);
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public String toString() {
        if (this == NO_PROXY) {
            return "(no proxy)";
        }
        return this.host() + ":" + this.port();
    }
}

