/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.mapping.put;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.ElasticsearchGenerationException;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.hppc.ObjectOpenHashSet;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;

public class PutMappingRequest
extends AcknowledgedRequest<PutMappingRequest> {
    private static ObjectOpenHashSet<String> RESERVED_FIELDS = ObjectOpenHashSet.from("_uid", "_id", "_type", "_source", "_all", "_analyzer", "_boost", "_parent", "_routing", "_index", "_size", "_timestamp", "_ttl");
    private String[] indices;
    private IndicesOptions indicesOptions = IndicesOptions.fromOptions(false, false, true, true);
    private String type;
    private String source;
    private boolean ignoreConflicts = false;

    PutMappingRequest() {
    }

    public PutMappingRequest(String ... indices) {
        this.indices = indices;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.type == null) {
            validationException = ValidateActions.addValidationError("mapping type is missing", validationException);
        }
        if (this.source == null) {
            validationException = ValidateActions.addValidationError("mapping source is missing", validationException);
        }
        return validationException;
    }

    public PutMappingRequest indices(String[] indices) {
        this.indices = indices;
        return this;
    }

    public String[] indices() {
        return this.indices;
    }

    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public PutMappingRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    public String type() {
        return this.type;
    }

    public PutMappingRequest type(String type) {
        this.type = type;
        return this;
    }

    public String source() {
        return this.source;
    }

    public PutMappingRequest source(Object ... source) {
        return this.source(PutMappingRequest.buildFromSimplifiedDef(this.type, source));
    }

    public static XContentBuilder buildFromSimplifiedDef(String type, Object ... source) {
        try {
            String[] s2;
            String[] s1;
            String fieldName;
            int i;
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.startObject();
            if (type != null) {
                builder.startObject(type);
            }
            for (i = 0; i < source.length; ++i) {
                if (!RESERVED_FIELDS.contains(fieldName = source[i++].toString())) continue;
                builder.startObject(fieldName);
                for (String s : s1 = Strings.splitStringByCommaToArray(source[i].toString())) {
                    s2 = Strings.split(s, "=");
                    if (s2.length != 2) {
                        throw new ElasticsearchIllegalArgumentException("malformed " + s);
                    }
                    builder.field(s2[0], s2[1]);
                }
                builder.endObject();
            }
            builder.startObject("properties");
            for (i = 0; i < source.length; ++i) {
                if (RESERVED_FIELDS.contains(fieldName = source[i++].toString())) continue;
                builder.startObject(fieldName);
                for (String s : s1 = Strings.splitStringByCommaToArray(source[i].toString())) {
                    s2 = Strings.split(s, "=");
                    if (s2.length != 2) {
                        throw new ElasticsearchIllegalArgumentException("malformed " + s);
                    }
                    builder.field(s2[0], s2[1]);
                }
                builder.endObject();
            }
            builder.endObject();
            if (type != null) {
                builder.endObject();
            }
            builder.endObject();
            return builder;
        }
        catch (Exception e) {
            throw new ElasticsearchIllegalArgumentException("failed to generate simplified mapping definition", e);
        }
    }

    public PutMappingRequest source(XContentBuilder mappingBuilder) {
        try {
            return this.source(mappingBuilder.string());
        }
        catch (IOException e) {
            throw new ElasticsearchIllegalArgumentException("Failed to build json for mapping request", e);
        }
    }

    public PutMappingRequest source(Map mappingSource) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON);
            builder.map(mappingSource);
            return this.source(builder.string());
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate [" + mappingSource + "]", e);
        }
    }

    public PutMappingRequest source(String mappingSource) {
        this.source = mappingSource;
        return this;
    }

    public boolean ignoreConflicts() {
        return this.ignoreConflicts;
    }

    public PutMappingRequest ignoreConflicts(boolean ignoreDuplicates) {
        this.ignoreConflicts = ignoreDuplicates;
        return this;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.indices = in.readStringArray();
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
        this.type = in.readOptionalString();
        this.source = in.readString();
        this.readTimeout(in);
        this.ignoreConflicts = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArrayNullable(this.indices);
        this.indicesOptions.writeIndicesOptions(out);
        out.writeOptionalString(this.type);
        out.writeString(this.source);
        this.writeTimeout(out);
        out.writeBoolean(this.ignoreConflicts);
    }
}

