/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.master;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.support.master.MasterNodeOperationRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public abstract class MasterNodeReadOperationRequest<T extends MasterNodeReadOperationRequest>
extends MasterNodeOperationRequest<T> {
    protected boolean local = false;

    public final T local(boolean local) {
        this.local = local;
        return (T)this;
    }

    public final boolean local() {
        return this.local;
    }

    protected void readLocal(StreamInput in) throws IOException {
        this.readLocal(in, null);
    }

    protected void readLocal(StreamInput in, Version minVersion) throws IOException {
        if (minVersion == null || in.getVersion().onOrAfter(minVersion)) {
            this.local = in.readBoolean();
        }
    }

    protected void writeLocal(StreamOutput out) throws IOException {
        this.writeLocal(out, null);
    }

    protected void writeLocal(StreamOutput out, Version minVersion) throws IOException {
        if (minVersion == null || out.getVersion().onOrAfter(minVersion)) {
            out.writeBoolean(this.local);
        }
    }
}

