/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.single.shard;

import java.io.IOException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.NoShardAvailableActionException;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.action.support.TransportActions;
import org.elasticsearch.action.support.single.shard.SingleShardOperationRequest;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.BaseTransportResponseHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public abstract class TransportShardSingleOperationAction<Request extends SingleShardOperationRequest, Response extends ActionResponse>
extends TransportAction<Request, Response> {
    protected final ClusterService clusterService;
    protected final TransportService transportService;
    final String transportAction;
    final String transportShardAction;
    final String executor;

    protected TransportShardSingleOperationAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService) {
        super(settings, threadPool);
        this.clusterService = clusterService;
        this.transportService = transportService;
        this.transportAction = this.transportAction();
        this.transportShardAction = this.transportAction() + "/s";
        this.executor = this.executor();
        transportService.registerHandler(this.transportAction, new TransportHandler());
        transportService.registerHandler(this.transportShardAction, new ShardTransportHandler());
    }

    @Override
    protected void doExecute(Request request, ActionListener<Response> listener) {
        new AsyncSingleAction(this, (SingleShardOperationRequest)request, listener).start();
    }

    protected abstract String transportAction();

    protected abstract String executor();

    protected abstract Response shardOperation(Request var1, int var2) throws ElasticsearchException;

    protected abstract Request newRequest();

    protected abstract Response newResponse();

    protected abstract ClusterBlockException checkGlobalBlock(ClusterState var1, Request var2);

    protected abstract ClusterBlockException checkRequestBlock(ClusterState var1, Request var2);

    protected void resolveRequest(ClusterState state, Request request) {
        ((SingleShardOperationRequest)request).index(state.metaData().concreteIndex(((SingleShardOperationRequest)request).index()));
    }

    protected abstract ShardIterator shards(ClusterState var1, Request var2) throws ElasticsearchException;

    class ShardSingleOperationRequest
    extends TransportRequest {
        private Request request;
        private int shardId;
        final /* synthetic */ TransportShardSingleOperationAction this$0;

        ShardSingleOperationRequest(TransportShardSingleOperationAction transportShardSingleOperationAction) {
            this.this$0 = transportShardSingleOperationAction;
        }

        /*
         * WARNING - Possible parameter corruption
         */
        public ShardSingleOperationRequest(Request request, int shardId) {
            this.this$0 = (TransportShardSingleOperationAction)n;
            super((TransportRequest)request);
            this.request = request;
            this.shardId = shardId;
        }

        public Request request() {
            return this.request;
        }

        public int shardId() {
            return this.shardId;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.request = this.this$0.newRequest();
            ((SingleShardOperationRequest)this.request).readFrom(in);
            this.shardId = in.readVInt();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            ((SingleShardOperationRequest)this.request).writeTo(out);
            out.writeVInt(this.shardId);
        }
    }

    private class ShardTransportHandler
    extends BaseTransportRequestHandler<ShardSingleOperationRequest> {
        private ShardTransportHandler() {
        }

        @Override
        public ShardSingleOperationRequest newInstance() {
            return new ShardSingleOperationRequest(TransportShardSingleOperationAction.this);
        }

        @Override
        public String executor() {
            return TransportShardSingleOperationAction.this.executor;
        }

        @Override
        public void messageReceived(ShardSingleOperationRequest request, TransportChannel channel) throws Exception {
            Object response = TransportShardSingleOperationAction.this.shardOperation(request.request(), request.shardId());
            channel.sendResponse((TransportResponse)response);
        }
    }

    private class TransportHandler
    extends BaseTransportRequestHandler<Request> {
        private TransportHandler() {
        }

        @Override
        public Request newInstance() {
            return TransportShardSingleOperationAction.this.newRequest();
        }

        @Override
        public String executor() {
            return "same";
        }

        @Override
        public void messageReceived(Request request, final TransportChannel channel) throws Exception {
            ((ActionRequest)request).listenerThreaded(false);
            ((SingleShardOperationRequest)request).operationThreaded(true);
            TransportShardSingleOperationAction.this.execute(request, new ActionListener<Response>(){

                @Override
                public void onResponse(Response result) {
                    try {
                        channel.sendResponse((TransportResponse)result);
                    }
                    catch (Throwable e) {
                        this.onFailure(e);
                    }
                }

                @Override
                public void onFailure(Throwable e) {
                    try {
                        channel.sendResponse(e);
                    }
                    catch (Exception e1) {
                        TransportShardSingleOperationAction.this.logger.warn("failed to send response for get", e1, new Object[0]);
                    }
                }
            });
        }
    }

    static class AsyncSingleAction {
        private final ActionListener<Response> listener;
        private final ShardIterator shardIt;
        private final Request request;
        private final DiscoveryNodes nodes;
        private volatile Throwable lastFailure;
        final /* synthetic */ TransportShardSingleOperationAction this$0;

        private AsyncSingleAction(Request request, ActionListener<Response> listener) {
            this.this$0 = var1_1;
            this.request = request;
            this.listener = listener;
            ClusterState clusterState = var1_1.clusterService.state();
            this.nodes = clusterState.nodes();
            ClusterBlockException blockException = var1_1.checkGlobalBlock(clusterState, request);
            if (blockException != null) {
                throw blockException;
            }
            var1_1.resolveRequest(clusterState, request);
            blockException = var1_1.checkRequestBlock(clusterState, request);
            if (blockException != null) {
                throw blockException;
            }
            this.shardIt = var1_1.shards(clusterState, request);
        }

        public void start() {
            this.perform(null);
        }

        private void onFailure(ShardRouting shardRouting, Throwable e) {
            if (this.this$0.logger.isTraceEnabled() && e != null) {
                this.this$0.logger.trace("{}: failed to execute [{}]", e, shardRouting, this.request);
            }
            this.perform(e);
        }

        private void perform(@Nullable Throwable currentFailure) {
            block12: {
                ShardRouting shardRouting;
                Throwable lastFailure = this.lastFailure;
                if (lastFailure == null || TransportActions.isReadOverrideException(currentFailure)) {
                    lastFailure = currentFailure;
                    this.lastFailure = currentFailure;
                }
                if ((shardRouting = this.shardIt.nextOrNull()) == null) {
                    Throwable failure = lastFailure;
                    if (failure == null || TransportActions.isShardNotAvailableException(failure)) {
                        failure = new NoShardAvailableActionException(this.shardIt.shardId());
                    } else if (this.this$0.logger.isDebugEnabled()) {
                        this.this$0.logger.debug("{}: failed to execute [{}]", failure, this.shardIt.shardId(), this.request);
                    }
                    this.listener.onFailure(failure);
                    return;
                }
                if (shardRouting.currentNodeId().equals(this.nodes.localNodeId())) {
                    try {
                        if (((SingleShardOperationRequest)this.request).operationThreaded()) {
                            ((SingleShardOperationRequest)this.request).beforeLocalFork();
                            this.this$0.threadPool.executor(this.this$0.executor).execute(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        Object response = AsyncSingleAction.this.this$0.shardOperation(AsyncSingleAction.this.request, shardRouting.id());
                                        AsyncSingleAction.this.listener.onResponse(response);
                                    }
                                    catch (Throwable e) {
                                        AsyncSingleAction.this.onFailure(shardRouting, e);
                                    }
                                }
                            });
                            break block12;
                        }
                        Object response = this.this$0.shardOperation(this.request, shardRouting.id());
                        this.listener.onResponse(response);
                    }
                    catch (Throwable e) {
                        this.onFailure(shardRouting, e);
                    }
                } else {
                    DiscoveryNode node = this.nodes.get(shardRouting.currentNodeId());
                    if (node == null) {
                        this.onFailure(shardRouting, new NoShardAvailableActionException(this.shardIt.shardId()));
                    } else {
                        this.this$0.transportService.sendRequest(node, this.this$0.transportShardAction, new ShardSingleOperationRequest(this.this$0, this.request, shardRouting.id()), new BaseTransportResponseHandler<Response>(){

                            @Override
                            public Response newInstance() {
                                return AsyncSingleAction.this.this$0.newResponse();
                            }

                            @Override
                            public String executor() {
                                return "same";
                            }

                            @Override
                            public void handleResponse(Response response) {
                                AsyncSingleAction.this.listener.onResponse(response);
                            }

                            @Override
                            public void handleException(TransportException exp) {
                                AsyncSingleAction.this.onFailure(shardRouting, exp);
                            }
                        });
                    }
                }
            }
        }
    }
}

