/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import java.io.IOException;
import org.elasticsearch.cluster.metadata.SnapshotId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class RestoreSource
implements Streamable,
ToXContent {
    private SnapshotId snapshotId;
    private String index;

    RestoreSource() {
    }

    public RestoreSource(SnapshotId snapshotId, String index) {
        this.snapshotId = snapshotId;
        this.index = index;
    }

    public SnapshotId snapshotId() {
        return this.snapshotId;
    }

    public String index() {
        return this.index;
    }

    public static RestoreSource readRestoreSource(StreamInput in) throws IOException {
        RestoreSource restoreSource = new RestoreSource();
        restoreSource.readFrom(in);
        return restoreSource;
    }

    public static RestoreSource readOptionalRestoreSource(StreamInput in) throws IOException {
        return in.readOptionalStreamable(new RestoreSource());
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.snapshotId = SnapshotId.readSnapshotId(in);
        this.index = in.readString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.snapshotId.writeTo(out);
        out.writeString(this.index);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().field("repository", this.snapshotId.getRepository()).field("snapshot", this.snapshotId.getSnapshot()).field("index", this.index).endObject();
    }

    public String toString() {
        return this.snapshotId.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestoreSource that = (RestoreSource)o;
        if (!this.index.equals(that.index)) {
            return false;
        }
        return this.snapshotId.equals(that.snapshotId);
    }

    public int hashCode() {
        int result = this.snapshotId.hashCode();
        result = 31 * result + this.index.hashCode();
        return result;
    }
}

