/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.decider;

import org.elasticsearch.cluster.routing.MutableShardRouting;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;

public class SameShardAllocationDecider
extends AllocationDecider {
    public static final String SAME_HOST_SETTING = "cluster.routing.allocation.same_shard.host";
    private final boolean sameHost;

    @Inject
    public SameShardAllocationDecider(Settings settings) {
        super(settings);
        this.sameHost = settings.getAsBoolean(SAME_HOST_SETTING, (Boolean)false);
    }

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        Iterable<MutableShardRouting> assignedShards = allocation.routingNodes().assignedShards(shardRouting);
        for (MutableShardRouting assignedShard : assignedShards) {
            if (!node.nodeId().equals(assignedShard.currentNodeId())) continue;
            return allocation.decision(Decision.NO, "shard cannot be allocated on same node [%s] it already exists on", node.nodeId());
        }
        if (this.sameHost && node.node() != null) {
            for (RoutingNode checkNode : allocation.routingNodes()) {
                if (checkNode.node() == null) continue;
                boolean checkNodeOnSameHost = false;
                if (Strings.hasLength(checkNode.node().getHostAddress()) && Strings.hasLength(node.node().getHostAddress())) {
                    if (checkNode.node().getHostAddress().equals(node.node().getHostAddress())) {
                        checkNodeOnSameHost = true;
                    }
                } else if (Strings.hasLength(checkNode.node().getHostName()) && Strings.hasLength(node.node().getHostName()) && checkNode.node().getHostName().equals(node.node().getHostName())) {
                    checkNodeOnSameHost = true;
                }
                if (!checkNodeOnSameHost) continue;
                for (MutableShardRouting assignedShard : assignedShards) {
                    if (!checkNode.nodeId().equals(assignedShard.currentNodeId())) continue;
                    return allocation.decision(Decision.NO, "shard cannot be allocated on same host [%s] it already exists on", node.nodeId());
                }
            }
        }
        return allocation.decision(Decision.YES, "shard is not allocated to same node or host", new Object[0]);
    }
}

