/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.blobstore;

import java.util.Iterator;
import org.elasticsearch.common.collect.ImmutableList;

public class BlobPath
implements Iterable<String> {
    private final ImmutableList<String> paths;

    public BlobPath() {
        this.paths = ImmutableList.of();
    }

    public static BlobPath cleanPath() {
        return new BlobPath();
    }

    private BlobPath(ImmutableList<String> paths) {
        this.paths = paths;
    }

    @Override
    public Iterator<String> iterator() {
        return this.paths.iterator();
    }

    public String[] toArray() {
        return this.paths.toArray(new String[this.paths.size()]);
    }

    public BlobPath add(String path) {
        ImmutableList.Builder builder = ImmutableList.builder();
        return new BlobPath((ImmutableList<String>)((ImmutableList.Builder)((ImmutableList.Builder)builder.addAll(this.paths)).add(path)).build());
    }

    public String buildAsString(String separator) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.paths.size(); ++i) {
            sb.append((String)this.paths.get(i));
            if (i >= this.paths.size() - 1) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String path : this.paths) {
            sb.append('[').append(path).append(']');
        }
        return sb.toString();
    }
}

