/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.netty.channel.socket.nio;

import org.elasticsearch.common.netty.channel.AbstractChannelSink;
import org.elasticsearch.common.netty.channel.Channel;
import org.elasticsearch.common.netty.channel.ChannelEvent;
import org.elasticsearch.common.netty.channel.ChannelFuture;
import org.elasticsearch.common.netty.channel.ChannelPipeline;
import org.elasticsearch.common.netty.channel.socket.ChannelRunnableWrapper;
import org.elasticsearch.common.netty.channel.socket.nio.AbstractNioChannel;
import org.elasticsearch.common.netty.channel.socket.nio.AbstractNioWorker;

public abstract class AbstractNioChannelSink
extends AbstractChannelSink {
    public ChannelFuture execute(ChannelPipeline pipeline, Runnable task) {
        Channel ch = pipeline.getChannel();
        if (ch instanceof AbstractNioChannel) {
            AbstractNioChannel channel = (AbstractNioChannel)ch;
            ChannelRunnableWrapper wrapper = new ChannelRunnableWrapper(pipeline.getChannel(), task);
            channel.worker.executeInIoThread(wrapper);
            return wrapper;
        }
        return super.execute(pipeline, task);
    }

    protected boolean isFireExceptionCaughtLater(ChannelEvent event, Throwable actualCause) {
        Channel channel = event.getChannel();
        boolean fireLater = false;
        if (channel instanceof AbstractNioChannel) {
            fireLater = !AbstractNioWorker.isIoThread((AbstractNioChannel)channel);
        }
        return fireLater;
    }
}

