/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.netty.handler.codec.oneone;

import org.elasticsearch.common.netty.channel.Channel;
import org.elasticsearch.common.netty.channel.ChannelEvent;
import org.elasticsearch.common.netty.channel.ChannelHandlerContext;
import org.elasticsearch.common.netty.channel.ChannelUpstreamHandler;
import org.elasticsearch.common.netty.channel.Channels;
import org.elasticsearch.common.netty.channel.MessageEvent;

public abstract class OneToOneDecoder
implements ChannelUpstreamHandler {
    protected OneToOneDecoder() {
    }

    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent evt) throws Exception {
        Object decodedMessage;
        if (!(evt instanceof MessageEvent)) {
            ctx.sendUpstream(evt);
            return;
        }
        MessageEvent e = (MessageEvent)evt;
        Object originalMessage = e.getMessage();
        if (originalMessage == (decodedMessage = this.decode(ctx, e.getChannel(), originalMessage))) {
            ctx.sendUpstream(evt);
        } else if (decodedMessage != null) {
            Channels.fireMessageReceived(ctx, decodedMessage, e.getRemoteAddress());
        }
    }

    protected abstract Object decode(ChannelHandlerContext var1, Channel var2, Object var3) throws Exception;
}

