/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.internal;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.base.Objects;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.compress.CompressedStreamInput;
import org.elasticsearch.common.compress.CompressedStreamOutput;
import org.elasticsearch.common.compress.Compressor;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.InternalMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeContext;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.RootMapper;
import org.elasticsearch.index.mapper.core.AbstractFieldMapper;

public class SourceFieldMapper
extends AbstractFieldMapper<byte[]>
implements InternalMapper,
RootMapper {
    public static final String NAME = "_source";
    public static final String CONTENT_TYPE = "_source";
    private final boolean enabled;
    private Boolean compress;
    private long compressThreshold;
    private String[] includes;
    private String[] excludes;
    private String format;
    private XContentType formatContentType;

    public SourceFieldMapper() {
        this("_source", true, Defaults.FORMAT, null, -1L, null, null);
    }

    protected SourceFieldMapper(String name, boolean enabled, String format, Boolean compress, long compressThreshold, String[] includes, String[] excludes) {
        super(new FieldMapper.Names(name, name, name, name), 1.0f, new FieldType(Defaults.FIELD_TYPE), null, Lucene.KEYWORD_ANALYZER, Lucene.KEYWORD_ANALYZER, null, null, null, null, null, null);
        this.enabled = enabled;
        this.compress = compress;
        this.compressThreshold = compressThreshold;
        this.includes = includes;
        this.excludes = excludes;
        this.format = format;
        this.formatContentType = format == null ? null : XContentType.fromRestContentType(format);
    }

    public boolean enabled() {
        return this.enabled;
    }

    public String[] excludes() {
        return this.excludes != null ? this.excludes : Strings.EMPTY_ARRAY;
    }

    public String[] includes() {
        return this.includes != null ? this.includes : Strings.EMPTY_ARRAY;
    }

    @Override
    public FieldType defaultFieldType() {
        return Defaults.FIELD_TYPE;
    }

    @Override
    public FieldDataType defaultFieldDataType() {
        return null;
    }

    @Override
    public boolean hasDocValues() {
        return false;
    }

    @Override
    public void preParse(ParseContext context) throws IOException {
        super.parse(context);
    }

    @Override
    public void postParse(ParseContext context) throws IOException {
    }

    @Override
    public void parse(ParseContext context) throws IOException {
    }

    @Override
    public void validate(ParseContext context) throws MapperParsingException {
    }

    @Override
    public boolean includeInObject() {
        return false;
    }

    @Override
    protected void parseCreateField(ParseContext context, List<Field> fields) throws IOException {
        boolean filtered;
        if (!this.enabled) {
            return;
        }
        if (!this.fieldType.stored()) {
            return;
        }
        if (context.flyweight()) {
            return;
        }
        BytesReference source = context.source();
        boolean bl = filtered = this.includes != null && this.includes.length > 0 || this.excludes != null && this.excludes.length > 0;
        if (filtered) {
            XContentType contentType;
            BytesStreamOutput bStream;
            Tuple<XContentType, Map<String, Object>> mapTuple = XContentHelper.convertToMap(source, true);
            Map<String, Object> filteredSource = XContentMapValues.filter(mapTuple.v2(), this.includes, this.excludes);
            StreamOutput streamOutput = bStream = new BytesStreamOutput();
            if (this.compress != null && this.compress.booleanValue() && (this.compressThreshold == -1L || (long)source.length() > this.compressThreshold)) {
                streamOutput = CompressorFactory.defaultCompressor().streamOutput(bStream);
            }
            if ((contentType = this.formatContentType) == null) {
                contentType = mapTuple.v1();
            }
            XContentBuilder builder = XContentFactory.contentBuilder(contentType, streamOutput).map(filteredSource);
            builder.close();
            source = bStream.bytes();
        } else if (this.compress != null && this.compress.booleanValue() && !CompressorFactory.isCompressed(source)) {
            if (this.compressThreshold == -1L || (long)source.length() > this.compressThreshold) {
                BytesStreamOutput bStream = new BytesStreamOutput();
                XContentType contentType = XContentFactory.xContentType(source);
                if (this.formatContentType != null && this.formatContentType != contentType) {
                    XContentBuilder builder = XContentFactory.contentBuilder(this.formatContentType, CompressorFactory.defaultCompressor().streamOutput(bStream));
                    builder.copyCurrentStructure(XContentFactory.xContent(contentType).createParser(source));
                    builder.close();
                } else {
                    CompressedStreamOutput streamOutput = CompressorFactory.defaultCompressor().streamOutput(bStream);
                    source.writeTo(streamOutput);
                    ((StreamOutput)streamOutput).close();
                }
                source = bStream.bytes();
                context.source(source);
            }
        } else if (this.formatContentType != null) {
            Compressor compressor = CompressorFactory.compressor(source);
            if (compressor != null) {
                CompressedStreamInput compressedStreamInput = compressor.streamInput(source.streamInput());
                XContentType contentType = XContentFactory.xContentType(compressedStreamInput);
                compressedStreamInput.resetToBufferStart();
                if (contentType != this.formatContentType) {
                    BytesStreamOutput bStream = new BytesStreamOutput();
                    CompressedStreamOutput streamOutput = CompressorFactory.defaultCompressor().streamOutput(bStream);
                    XContentBuilder builder = XContentFactory.contentBuilder(this.formatContentType, streamOutput);
                    builder.copyCurrentStructure(XContentFactory.xContent(contentType).createParser(compressedStreamInput));
                    builder.close();
                    source = bStream.bytes();
                    context.source(source);
                } else {
                    compressedStreamInput.close();
                }
            } else {
                XContentType contentType = XContentFactory.xContentType(source);
                if (contentType != this.formatContentType) {
                    BytesStreamOutput bStream = new BytesStreamOutput();
                    XContentBuilder builder = XContentFactory.contentBuilder(this.formatContentType, bStream);
                    builder.copyCurrentStructure(XContentFactory.xContent(contentType).createParser(source));
                    builder.close();
                    source = bStream.bytes();
                    context.source(source);
                }
            }
        }
        assert (source.hasArray());
        fields.add((Field)new StoredField(this.names().indexName(), source.array(), source.arrayOffset(), source.length()));
    }

    @Override
    public byte[] value(Object value) {
        if (value == null) {
            return null;
        }
        BytesReference bValue = value instanceof BytesRef ? new BytesArray((BytesRef)value) : (BytesReference)value;
        try {
            return CompressorFactory.uncompressIfNeeded(bValue).toBytes();
        }
        catch (IOException e) {
            throw new ElasticsearchParseException("failed to decompress source", e);
        }
    }

    @Override
    protected String contentType() {
        return "_source";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean includeDefaults = params.paramAsBoolean("include_defaults", false);
        if (!includeDefaults && this.enabled && this.compress == null && this.compressThreshold == -1L && this.includes == null && this.excludes == null) {
            return builder;
        }
        builder.startObject(this.contentType());
        if (includeDefaults || !this.enabled) {
            builder.field("enabled", this.enabled);
        }
        if (includeDefaults || !Objects.equal(this.format, Defaults.FORMAT)) {
            builder.field("format", this.format);
        }
        if (this.compress != null) {
            builder.field("compress", (Object)this.compress);
        } else if (includeDefaults) {
            builder.field("compress", false);
        }
        if (this.compressThreshold != -1L) {
            builder.field("compress_threshold", new ByteSizeValue(this.compressThreshold).toString());
        } else if (includeDefaults) {
            builder.field("compress_threshold", -1);
        }
        if (this.includes != null) {
            builder.field("includes", this.includes);
        } else if (includeDefaults) {
            builder.field("includes", Strings.EMPTY_ARRAY);
        }
        if (this.excludes != null) {
            builder.field("excludes", this.excludes);
        } else if (includeDefaults) {
            builder.field("excludes", Strings.EMPTY_ARRAY);
        }
        builder.endObject();
        return builder;
    }

    @Override
    public void merge(Mapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
        SourceFieldMapper sourceMergeWith = (SourceFieldMapper)mergeWith;
        if (!mergeContext.mergeFlags().simulate()) {
            if (sourceMergeWith.compress != null) {
                this.compress = sourceMergeWith.compress;
            }
            if (sourceMergeWith.compressThreshold != -1L) {
                this.compressThreshold = sourceMergeWith.compressThreshold;
            }
            if (sourceMergeWith.includes != null) {
                this.includes = sourceMergeWith.includes;
            }
            if (sourceMergeWith.excludes != null) {
                this.excludes = sourceMergeWith.excludes;
            }
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = MapperBuilders.source();
            for (Map.Entry<String, Object> entry : node.entrySet()) {
                int i;
                List values;
                String fieldName = Strings.toUnderscoreCase(entry.getKey());
                Object fieldNode = entry.getValue();
                if (fieldName.equals("enabled")) {
                    builder.enabled(XContentMapValues.nodeBooleanValue(fieldNode));
                    continue;
                }
                if (fieldName.equals("compress") && fieldNode != null) {
                    builder.compress(XContentMapValues.nodeBooleanValue(fieldNode));
                    continue;
                }
                if (fieldName.equals("compress_threshold") && fieldNode != null) {
                    if (fieldNode instanceof Number) {
                        builder.compressThreshold(((Number)fieldNode).longValue());
                        builder.compress(true);
                        continue;
                    }
                    builder.compressThreshold(ByteSizeValue.parseBytesSizeValue(fieldNode.toString()).bytes());
                    builder.compress(true);
                    continue;
                }
                if ("format".equals(fieldName)) {
                    builder.format(XContentMapValues.nodeStringValue(fieldNode, null));
                    continue;
                }
                if (fieldName.equals("includes")) {
                    values = (List)fieldNode;
                    String[] includes = new String[values.size()];
                    for (i = 0; i < includes.length; ++i) {
                        includes[i] = values.get(i).toString();
                    }
                    builder.includes(includes);
                    continue;
                }
                if (!fieldName.equals("excludes")) continue;
                values = (List)fieldNode;
                String[] excludes = new String[values.size()];
                for (i = 0; i < excludes.length; ++i) {
                    excludes[i] = values.get(i).toString();
                }
                builder.excludes(excludes);
            }
            return builder;
        }
    }

    public static class Builder
    extends Mapper.Builder<Builder, SourceFieldMapper> {
        private boolean enabled = true;
        private long compressThreshold = -1L;
        private Boolean compress = null;
        private String format = Defaults.FORMAT;
        private String[] includes = null;
        private String[] excludes = null;

        public Builder() {
            super("_source");
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder compress(boolean compress) {
            this.compress = compress;
            return this;
        }

        public Builder compressThreshold(long compressThreshold) {
            this.compressThreshold = compressThreshold;
            return this;
        }

        public Builder format(String format) {
            this.format = format;
            return this;
        }

        public Builder includes(String[] includes) {
            this.includes = includes;
            return this;
        }

        public Builder excludes(String[] excludes) {
            this.excludes = excludes;
            return this;
        }

        @Override
        public SourceFieldMapper build(Mapper.BuilderContext context) {
            return new SourceFieldMapper(this.name, this.enabled, this.format, this.compress, this.compressThreshold, this.includes, this.excludes);
        }
    }

    public static class Defaults
    extends AbstractFieldMapper.Defaults {
        public static final String NAME = "_source";
        public static final boolean ENABLED = true;
        public static final long COMPRESS_THRESHOLD = -1L;
        public static final String FORMAT = null;
        public static final FieldType FIELD_TYPE = new FieldType(AbstractFieldMapper.Defaults.FIELD_TYPE);

        static {
            FIELD_TYPE.setIndexed(false);
            FIELD_TYPE.setStored(true);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setIndexOptions(FieldInfo.IndexOptions.DOCS_ONLY);
            FIELD_TYPE.freeze();
        }
    }
}

