/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BaseQueryBuilder;
import org.elasticsearch.index.query.BoostableQueryBuilder;
import org.elasticsearch.index.query.SpanQueryBuilder;

public class FieldMaskingSpanQueryBuilder
extends BaseQueryBuilder
implements SpanQueryBuilder,
BoostableQueryBuilder<FieldMaskingSpanQueryBuilder> {
    private final SpanQueryBuilder queryBuilder;
    private final String field;
    private float boost = -1.0f;
    private String queryName;

    public FieldMaskingSpanQueryBuilder(SpanQueryBuilder queryBuilder, String field) {
        this.queryBuilder = queryBuilder;
        this.field = field;
    }

    @Override
    public FieldMaskingSpanQueryBuilder boost(float boost) {
        this.boost = boost;
        return this;
    }

    public FieldMaskingSpanQueryBuilder queryName(String queryName) {
        this.queryName = queryName;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("field_masking_span");
        builder.field("query");
        this.queryBuilder.toXContent(builder, params);
        builder.field("field", this.field);
        if (this.boost != -1.0f) {
            builder.field("boost", this.boost);
        }
        if (this.queryName != null) {
            builder.field("_name", this.queryName);
        }
        builder.endObject();
    }
}

