/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BaseQueryBuilder;
import org.elasticsearch.index.query.BoostableQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;

public class HasChildQueryBuilder
extends BaseQueryBuilder
implements BoostableQueryBuilder<HasChildQueryBuilder> {
    private final QueryBuilder queryBuilder;
    private String childType;
    private float boost = 1.0f;
    private String scoreType;
    private Integer shortCircuitCutoff;
    private String queryName;

    public HasChildQueryBuilder(String type, QueryBuilder queryBuilder) {
        this.childType = type;
        this.queryBuilder = queryBuilder;
    }

    @Override
    public HasChildQueryBuilder boost(float boost) {
        this.boost = boost;
        return this;
    }

    public HasChildQueryBuilder scoreType(String scoreType) {
        this.scoreType = scoreType;
        return this;
    }

    public HasChildQueryBuilder setShortCircuitCutoff(int shortCircuitCutoff) {
        this.shortCircuitCutoff = shortCircuitCutoff;
        return this;
    }

    public HasChildQueryBuilder queryName(String queryName) {
        this.queryName = queryName;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("has_child");
        builder.field("query");
        this.queryBuilder.toXContent(builder, params);
        builder.field("child_type", this.childType);
        if (this.boost != 1.0f) {
            builder.field("boost", this.boost);
        }
        if (this.scoreType != null) {
            builder.field("score_type", this.scoreType);
        }
        if (this.shortCircuitCutoff != null) {
            builder.field("short_circuit_cutoff", this.shortCircuitCutoff);
        }
        if (this.queryName != null) {
            builder.field("_name", this.queryName);
        }
        builder.endObject();
    }
}

