/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.functionscore;

import java.io.IOException;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.functionscore.ScoreFunctionBuilder;

public abstract class DecayFunctionBuilder
implements ScoreFunctionBuilder {
    protected static final String ORIGIN = "origin";
    protected static final String SCALE = "scale";
    protected static final String DECAY = "decay";
    protected static final String OFFSET = "offset";
    private String fieldName;
    private Object origin;
    private Object scale;
    private double decay = -1.0;
    private Object offset;

    public DecayFunctionBuilder(String fieldName, Object origin, Object scale) {
        this.fieldName = fieldName;
        this.origin = origin;
        this.scale = scale;
    }

    public DecayFunctionBuilder setDecay(double decay) {
        if (decay <= 0.0 || decay >= 1.0) {
            throw new ElasticsearchIllegalStateException("scale weight parameter must be in range 0..1!");
        }
        this.decay = decay;
        return this;
    }

    public DecayFunctionBuilder setOffset(Object offset) {
        this.offset = offset;
        return this;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.getName());
        builder.startObject(this.fieldName);
        if (this.origin != null) {
            builder.field(ORIGIN, this.origin);
        }
        builder.field(SCALE, this.scale);
        if (this.decay > 0.0) {
            builder.field(DECAY, this.decay);
        }
        if (this.offset != null) {
            builder.field(OFFSET, this.offset);
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }
}

