/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.child;

import java.io.IOException;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

class ConstantScorer
extends Scorer {
    private final DocIdSetIterator docIdSetIterator;
    private final float constantScore;

    static ConstantScorer create(DocIdSetIterator iterator, Weight weight, float constantScore) throws IOException {
        return new ConstantScorer(iterator, weight, constantScore);
    }

    private ConstantScorer(DocIdSetIterator docIdSetIterator, Weight w, float constantScore) {
        super(w);
        this.constantScore = constantScore;
        this.docIdSetIterator = docIdSetIterator;
    }

    public int nextDoc() throws IOException {
        return this.docIdSetIterator.nextDoc();
    }

    public int docID() {
        return this.docIdSetIterator.docID();
    }

    public float score() throws IOException {
        assert (this.docIdSetIterator.docID() != Integer.MAX_VALUE);
        return this.constantScore;
    }

    public int freq() throws IOException {
        return 1;
    }

    public int advance(int target) throws IOException {
        return this.docIdSetIterator.advance(target);
    }

    public long cost() {
        return this.docIdSetIterator.cost();
    }
}

