/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.analysis;

import java.util.Locale;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ar.ArabicNormalizationFilter;
import org.apache.lucene.analysis.ar.ArabicStemFilter;
import org.apache.lucene.analysis.br.BrazilianStemFilter;
import org.apache.lucene.analysis.commongrams.CommonGramsFilter;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.core.StopAnalyzer;
import org.apache.lucene.analysis.core.StopFilter;
import org.apache.lucene.analysis.cz.CzechStemFilter;
import org.apache.lucene.analysis.de.GermanStemFilter;
import org.apache.lucene.analysis.en.KStemFilter;
import org.apache.lucene.analysis.en.PorterStemFilter;
import org.apache.lucene.analysis.fa.PersianNormalizationFilter;
import org.apache.lucene.analysis.fr.FrenchAnalyzer;
import org.apache.lucene.analysis.fr.FrenchStemFilter;
import org.apache.lucene.analysis.miscellaneous.ASCIIFoldingFilter;
import org.apache.lucene.analysis.miscellaneous.KeywordRepeatFilter;
import org.apache.lucene.analysis.miscellaneous.LengthFilter;
import org.apache.lucene.analysis.miscellaneous.TrimFilter;
import org.apache.lucene.analysis.miscellaneous.TruncateTokenFilter;
import org.apache.lucene.analysis.miscellaneous.UniqueTokenFilter;
import org.apache.lucene.analysis.miscellaneous.WordDelimiterFilter;
import org.apache.lucene.analysis.ngram.EdgeNGramTokenFilter;
import org.apache.lucene.analysis.ngram.NGramTokenFilter;
import org.apache.lucene.analysis.nl.DutchStemFilter;
import org.apache.lucene.analysis.payloads.TypeAsPayloadTokenFilter;
import org.apache.lucene.analysis.reverse.ReverseStringFilter;
import org.apache.lucene.analysis.shingle.ShingleFilter;
import org.apache.lucene.analysis.snowball.SnowballFilter;
import org.apache.lucene.analysis.standard.ClassicFilter;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.analysis.util.ElisionFilter;
import org.elasticsearch.Version;
import org.elasticsearch.index.analysis.TokenFilterFactory;
import org.elasticsearch.indices.analysis.PreBuiltCacheFactory;

public enum PreBuiltTokenFilters {
    WORD_DELIMITER(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version) {
            return new WordDelimiterFilter(tokenStream, 451, null);
        }
    }
    ,
    STOP(PreBuiltCacheFactory.CachingStrategy.LUCENE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version) {
            return new StopFilter(version.luceneVersion, tokenStream, StopAnalyzer.ENGLISH_STOP_WORDS_SET);
        }
    }
    ,
    TRIM(PreBuiltCacheFactory.CachingStrategy.LUCENE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version) {
            return new TrimFilter(version.luceneVersion, tokenStream);
        }
    }
    ,
    REVERSE(PreBuiltCacheFactory.CachingStrategy.LUCENE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version) {
            return new ReverseStringFilter(version.luceneVersion, tokenStream);
        }
    }
    ,
    ASCIIFOLDING(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version) {
            return new ASCIIFoldingFilter(tokenStream);
        }
    }
    ,
    LENGTH(PreBuiltCacheFactory.CachingStrategy.LUCENE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version) {
            return new LengthFilter(version.luceneVersion, tokenStream, 0, Integer.MAX_VALUE);
        }
    }
    ,
    COMMON_GRAMS(PreBuiltCacheFactory.CachingStrategy.LUCENE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version) {
            return new CommonGramsFilter(version.luceneVersion, tokenStream, CharArraySet.EMPTY_SET);
        }
    }
    ,
    LOWERCASE(PreBuiltCacheFactory.CachingStrategy.LUCENE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version) {
            return new LowerCaseFilter(version.luceneVersion, tokenStream);
        }
    }
    ,
    KSTEM(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version) {
            return new KStemFilter(tokenStream);
        }
    }
    ,
    PORTER_STEM(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version) {
            return new PorterStemFilter(tokenStream);
        }
    }
    ,
    STANDARD(PreBuiltCacheFactory.CachingStrategy.LUCENE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version) {
            return new StandardFilter(version.luceneVersion, tokenStream);
        }
    }
    ,
    CLASSIC(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version) {
            return new ClassicFilter(tokenStream);
        }
    }
    ,
    NGRAM(PreBuiltCacheFactory.CachingStrategy.LUCENE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version) {
            return new NGramTokenFilter(version.luceneVersion, tokenStream);
        }
    }
    ,
    EDGE_NGRAM(PreBuiltCacheFactory.CachingStrategy.LUCENE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version) {
            return new EdgeNGramTokenFilter(version.luceneVersion, tokenStream, 1, 1);
        }
    }
    ,
    UNIQUE(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version) {
            return new UniqueTokenFilter(tokenStream);
        }
    }
    ,
    TRUNCATE(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version) {
            return new TruncateTokenFilter(tokenStream, 10);
        }
    }
    ,
    SNOWBALL(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version) {
            return new SnowballFilter(tokenStream, "English");
        }
    }
    ,
    STEMMER(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version) {
            return new PorterStemFilter(tokenStream);
        }
    }
    ,
    ELISION(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version) {
            return new ElisionFilter(tokenStream, FrenchAnalyzer.DEFAULT_ARTICLES);
        }
    }
    ,
    ARABIC_STEM(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version) {
            return new ArabicStemFilter(tokenStream);
        }
    }
    ,
    BRAZILIAN_STEM(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version) {
            return new BrazilianStemFilter(tokenStream);
        }
    }
    ,
    CZECH_STEM(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version) {
            return new CzechStemFilter(tokenStream);
        }
    }
    ,
    DUTCH_STEM(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version) {
            return new DutchStemFilter(tokenStream);
        }
    }
    ,
    FRENCH_STEM(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version) {
            return new FrenchStemFilter(tokenStream);
        }
    }
    ,
    GERMAN_STEM(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version) {
            return new GermanStemFilter(tokenStream);
        }
    }
    ,
    RUSSIAN_STEM(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version) {
            return new SnowballFilter(tokenStream, "Russian");
        }
    }
    ,
    KEYWORD_REPEAT(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version) {
            return new KeywordRepeatFilter(tokenStream);
        }
    }
    ,
    ARABIC_NORMALIZATION(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version) {
            return new ArabicNormalizationFilter(tokenStream);
        }
    }
    ,
    PERSIAN_NORMALIZATION(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version) {
            return new PersianNormalizationFilter(tokenStream);
        }
    }
    ,
    TYPE_AS_PAYLOAD(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version) {
            return new TypeAsPayloadTokenFilter(tokenStream);
        }
    }
    ,
    SHINGLE(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        public TokenStream create(TokenStream tokenStream, Version version) {
            return new ShingleFilter(tokenStream);
        }
    };

    protected final PreBuiltCacheFactory.PreBuiltCache<TokenFilterFactory> cache;

    public abstract TokenStream create(TokenStream var1, Version var2);

    private PreBuiltTokenFilters(PreBuiltCacheFactory.CachingStrategy cachingStrategy) {
        this.cache = PreBuiltCacheFactory.getCache(cachingStrategy);
    }

    public synchronized TokenFilterFactory getTokenFilterFactory(final Version version) {
        TokenFilterFactory factory = this.cache.get(version);
        if (factory == null) {
            final String finalName = this.name();
            factory = new TokenFilterFactory(){

                @Override
                public String name() {
                    return finalName.toLowerCase(Locale.ROOT);
                }

                @Override
                public TokenStream create(TokenStream tokenStream) {
                    return PreBuiltTokenFilters.valueOf(finalName).create(tokenStream, version);
                }
            };
            this.cache.put(version, factory);
        }
        return factory;
    }

    public static PreBuiltTokenFilters getOrDefault(String name, PreBuiltTokenFilters defaultTokenFilter) {
        try {
            return PreBuiltTokenFilters.valueOf(name.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            return defaultTokenFilter;
        }
    }
}

