/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.cluster.settings;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsRequest;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.rest.AcknowledgedRestResponseActionListener;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.XContentThrowableRestResponse;

public class RestClusterUpdateSettingsAction
extends BaseRestHandler {
    @Inject
    public RestClusterUpdateSettingsAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.PUT, "/_cluster/settings", this);
    }

    @Override
    public void handleRequest(RestRequest request, RestChannel channel) {
        ClusterUpdateSettingsRequest clusterUpdateSettingsRequest = Requests.clusterUpdateSettingsRequest();
        clusterUpdateSettingsRequest.listenerThreaded(false);
        clusterUpdateSettingsRequest.timeout(request.paramAsTime("timeout", clusterUpdateSettingsRequest.timeout()));
        clusterUpdateSettingsRequest.masterNodeTimeout(request.paramAsTime("master_timeout", clusterUpdateSettingsRequest.masterNodeTimeout()));
        try {
            Map<String, Object> source = XContentFactory.xContent(request.content()).createParser(request.content()).mapAndClose();
            if (source.containsKey("transient")) {
                clusterUpdateSettingsRequest.transientSettings((Map)source.get("transient"));
            }
            if (source.containsKey("persistent")) {
                clusterUpdateSettingsRequest.persistentSettings((Map)source.get("persistent"));
            }
        }
        catch (Exception e) {
            try {
                channel.sendResponse(new XContentThrowableRestResponse(request, e));
            }
            catch (IOException e1) {
                this.logger.warn("Failed to send response", e1, new Object[0]);
            }
            return;
        }
        this.client.admin().cluster().updateSettings(clusterUpdateSettingsRequest, (ActionListener<ClusterUpdateSettingsResponse>)new AcknowledgedRestResponseActionListener<ClusterUpdateSettingsResponse>(request, channel, this.logger){

            @Override
            protected void addCustomFields(XContentBuilder builder, ClusterUpdateSettingsResponse response) throws IOException {
                builder.startObject("persistent");
                response.getPersistentSettings().toXContent(builder, this.request);
                builder.endObject();
                builder.startObject("transient");
                response.getTransientSettings().toXContent(builder, this.request);
                builder.endObject();
            }

            @Override
            public void onFailure(Throwable e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("failed to handle cluster state", e, new Object[0]);
                }
                super.onFailure(e);
            }
        });
    }
}

