/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.range.geodistance;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.common.geo.GeoDistance;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.DoubleValues;
import org.elasticsearch.index.fielddata.GeoPointValues;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.LongValues;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.search.SearchParseException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.bucket.range.InternalRange;
import org.elasticsearch.search.aggregations.bucket.range.RangeAggregator;
import org.elasticsearch.search.aggregations.bucket.range.geodistance.InternalGeoDistance;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.FieldContext;
import org.elasticsearch.search.aggregations.support.FieldDataSource;
import org.elasticsearch.search.aggregations.support.ValueSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.geopoints.GeoPointValuesSource;
import org.elasticsearch.search.aggregations.support.numeric.NumericValuesSource;
import org.elasticsearch.search.internal.SearchContext;

public class GeoDistanceParser
implements Aggregator.Parser {
    @Override
    public String type() {
        return InternalGeoDistance.TYPE.name();
    }

    private static String key(String key, double from, double to) {
        if (key != null) {
            return key;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(from == 0.0 ? "*" : Double.valueOf(from));
        sb.append("-");
        sb.append(Double.isInfinite(to) ? "*" : Double.valueOf(to));
        return sb.toString();
    }

    @Override
    public AggregatorFactory parse(String aggregationName, XContentParser parser, SearchContext context) throws IOException {
        XContentParser.Token token;
        String field = null;
        ArrayList<RangeAggregator.Range> ranges = null;
        GeoPoint origin = null;
        DistanceUnit unit = DistanceUnit.DEFAULT;
        GeoDistance distanceType = GeoDistance.DEFAULT;
        boolean keyed = false;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            double lon;
            double lat;
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                if ("field".equals(currentFieldName)) {
                    field = parser.text();
                    continue;
                }
                if ("unit".equals(currentFieldName)) {
                    unit = DistanceUnit.fromString(parser.text());
                    continue;
                }
                if ("distance_type".equals(currentFieldName) || "distanceType".equals(currentFieldName)) {
                    distanceType = GeoDistance.fromString(parser.text());
                    continue;
                }
                if ("point".equals(currentFieldName) || "origin".equals(currentFieldName) || "center".equals(currentFieldName)) {
                    origin = new GeoPoint();
                    origin.resetFromString(parser.text());
                    continue;
                }
                throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + aggregationName + "]: [" + currentFieldName + "].");
            }
            if (token == XContentParser.Token.VALUE_BOOLEAN) {
                if ("keyed".equals(currentFieldName)) {
                    keyed = parser.booleanValue();
                    continue;
                }
                throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + aggregationName + "]: [" + currentFieldName + "].");
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if ("ranges".equals(currentFieldName)) {
                    ranges = new ArrayList<RangeAggregator.Range>();
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        String fromAsStr = null;
                        String toAsStr = null;
                        double from = 0.0;
                        double to = Double.POSITIVE_INFINITY;
                        String key = null;
                        String toOrFromOrKey = null;
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            if (token == XContentParser.Token.FIELD_NAME) {
                                toOrFromOrKey = parser.currentName();
                                continue;
                            }
                            if (token == XContentParser.Token.VALUE_NUMBER) {
                                if ("from".equals(toOrFromOrKey)) {
                                    from = parser.doubleValue();
                                    continue;
                                }
                                if (!"to".equals(toOrFromOrKey)) continue;
                                to = parser.doubleValue();
                                continue;
                            }
                            if (token != XContentParser.Token.VALUE_STRING) continue;
                            if ("key".equals(toOrFromOrKey)) {
                                key = parser.text();
                                continue;
                            }
                            if ("from".equals(toOrFromOrKey)) {
                                fromAsStr = parser.text();
                                continue;
                            }
                            if (!"to".equals(toOrFromOrKey)) continue;
                            toAsStr = parser.text();
                        }
                        ranges.add(new RangeAggregator.Range(GeoDistanceParser.key(key, from, to), from, fromAsStr, to, toAsStr));
                    }
                    continue;
                }
                if ("point".equals(currentFieldName) || "origin".equals(currentFieldName) || "center".equals(currentFieldName)) {
                    lat = Double.NaN;
                    lon = Double.NaN;
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        if (Double.isNaN(lon)) {
                            lon = parser.doubleValue();
                            continue;
                        }
                        if (Double.isNaN(lat)) {
                            lat = parser.doubleValue();
                            continue;
                        }
                        throw new SearchParseException(context, "malformed [origin] geo point array in geo_distance aggregator [" + aggregationName + "]. " + "a geo point array must be of the form [lon, lat]");
                    }
                    origin = new GeoPoint(lat, lon);
                    continue;
                }
                throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + aggregationName + "]: [" + currentFieldName + "].");
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if ("point".equals(currentFieldName) || "origin".equals(currentFieldName) || "center".equals(currentFieldName)) {
                    lat = Double.NaN;
                    lon = Double.NaN;
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            currentFieldName = parser.currentName();
                            continue;
                        }
                        if (token != XContentParser.Token.VALUE_NUMBER) continue;
                        if ("lat".equals(currentFieldName)) {
                            lat = parser.doubleValue();
                            continue;
                        }
                        if (!"lon".equals(currentFieldName)) continue;
                        lon = parser.doubleValue();
                    }
                    if (Double.isNaN(lat) || Double.isNaN(lon)) {
                        throw new SearchParseException(context, "malformed [origin] geo point object. either [lat] or [lon] (or both) are missing in geo_distance aggregator [" + aggregationName + "]");
                    }
                    origin = new GeoPoint(lat, lon);
                    continue;
                }
                throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + aggregationName + "]: [" + currentFieldName + "].");
            }
            throw new SearchParseException(context, "Unexpected token " + (Object)((Object)token) + " in [" + aggregationName + "].");
        }
        if (ranges == null) {
            throw new SearchParseException(context, "Missing [ranges] in geo_distance aggregator [" + aggregationName + "]");
        }
        if (origin == null) {
            throw new SearchParseException(context, "Missing [origin] in geo_distance aggregator [" + aggregationName + "]");
        }
        ValuesSourceConfig<GeoPointValuesSource> config = new ValuesSourceConfig<GeoPointValuesSource>(GeoPointValuesSource.class);
        if (field == null) {
            return new GeoDistanceFactory(aggregationName, config, InternalGeoDistance.FACTORY, origin, unit, distanceType, ranges, keyed);
        }
        FieldMapper mapper = context.smartNameFieldMapper(field);
        if (mapper == null) {
            config.unmapped(true);
            return new GeoDistanceFactory(aggregationName, config, InternalGeoDistance.FACTORY, origin, unit, distanceType, ranges, keyed);
        }
        Object indexFieldData = context.fieldData().getForField(mapper);
        config.fieldContext(new FieldContext(field, (IndexFieldData<?>)indexFieldData));
        return new GeoDistanceFactory(aggregationName, config, InternalGeoDistance.FACTORY, origin, unit, distanceType, ranges, keyed);
    }

    private static class GeoDistanceFactory
    extends ValueSourceAggregatorFactory<GeoPointValuesSource> {
        private final GeoPoint origin;
        private final DistanceUnit unit;
        private final GeoDistance distanceType;
        private final InternalRange.Factory rangeFactory;
        private final List<RangeAggregator.Range> ranges;
        private final boolean keyed;

        public GeoDistanceFactory(String name, ValuesSourceConfig<GeoPointValuesSource> valueSourceConfig, InternalRange.Factory rangeFactory, GeoPoint origin, DistanceUnit unit, GeoDistance distanceType, List<RangeAggregator.Range> ranges, boolean keyed) {
            super(name, rangeFactory.type(), valueSourceConfig);
            this.origin = origin;
            this.unit = unit;
            this.distanceType = distanceType;
            this.rangeFactory = rangeFactory;
            this.ranges = ranges;
            this.keyed = keyed;
        }

        @Override
        protected Aggregator createUnmapped(AggregationContext aggregationContext, Aggregator parent) {
            return new RangeAggregator.Unmapped(this.name, this.ranges, this.keyed, this.valuesSourceConfig.formatter(), this.valuesSourceConfig.parser(), aggregationContext, parent, this.rangeFactory);
        }

        @Override
        protected Aggregator create(GeoPointValuesSource valuesSource, long expectedBucketsCount, AggregationContext aggregationContext, Aggregator parent) {
            DistanceValues distanceValues = new DistanceValues(valuesSource, this.distanceType, this.origin, this.unit);
            FieldDataSource.Numeric distanceSource = new DistanceSource(distanceValues, valuesSource.metaData());
            if (((FieldDataSource)distanceSource).metaData().multiValued()) {
                distanceSource = new FieldDataSource.Numeric.SortedAndUnique(distanceSource);
            }
            NumericValuesSource numericSource = new NumericValuesSource(distanceSource, null, null);
            return new RangeAggregator(this.name, this.factories, numericSource, this.rangeFactory, this.ranges, this.keyed, aggregationContext, parent);
        }

        private static class DistanceSource
        extends FieldDataSource.Numeric {
            private final DoubleValues values;
            private final FieldDataSource.MetaData metaData;

            public DistanceSource(DoubleValues values, FieldDataSource.MetaData metaData) {
                this.values = values;
                this.metaData = FieldDataSource.MetaData.builder(metaData).uniqueness(FieldDataSource.MetaData.Uniqueness.UNKNOWN).build();
            }

            @Override
            public FieldDataSource.MetaData metaData() {
                return this.metaData;
            }

            @Override
            public boolean isFloatingPoint() {
                return true;
            }

            @Override
            public LongValues longValues() {
                throw new UnsupportedOperationException();
            }

            @Override
            public DoubleValues doubleValues() {
                return this.values;
            }

            @Override
            public BytesValues bytesValues() {
                throw new UnsupportedOperationException();
            }
        }

        private static class DistanceValues
        extends DoubleValues {
            private final GeoPointValuesSource geoPointValues;
            private GeoPointValues geoValues;
            private final GeoDistance distanceType;
            private final GeoPoint origin;
            private final DistanceUnit unit;

            protected DistanceValues(GeoPointValuesSource geoPointValues, GeoDistance distanceType, GeoPoint origin, DistanceUnit unit) {
                super(true);
                this.geoPointValues = geoPointValues;
                this.distanceType = distanceType;
                this.origin = origin;
                this.unit = unit;
            }

            @Override
            public int setDocument(int docId) {
                this.geoValues = this.geoPointValues.values();
                return this.geoValues.setDocument(docId);
            }

            @Override
            public double nextValue() {
                GeoPoint target = this.geoValues.nextValue();
                return this.distanceType.calculate(this.origin.getLat(), this.origin.getLon(), target.getLat(), target.getLon(), this.unit);
            }
        }
    }
}

