/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.range.ipv4;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.ip.IpFieldMapper;
import org.elasticsearch.search.SearchParseException;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.bucket.range.RangeAggregator;
import org.elasticsearch.search.aggregations.bucket.range.ipv4.IPv4RangeBuilder;
import org.elasticsearch.search.aggregations.bucket.range.ipv4.InternalIPv4Range;
import org.elasticsearch.search.aggregations.support.FieldContext;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.numeric.NumericValuesSource;
import org.elasticsearch.search.aggregations.support.numeric.ValueFormatter;
import org.elasticsearch.search.aggregations.support.numeric.ValueParser;
import org.elasticsearch.search.internal.SearchContext;

public class IpRangeParser
implements Aggregator.Parser {
    @Override
    public String type() {
        return InternalIPv4Range.TYPE.name();
    }

    @Override
    public AggregatorFactory parse(String aggregationName, XContentParser parser, SearchContext context) throws IOException {
        XContentParser.Token token;
        ValuesSourceConfig<NumericValuesSource> config = new ValuesSourceConfig<NumericValuesSource>(NumericValuesSource.class);
        String field = null;
        ArrayList<RangeAggregator.Range> ranges = null;
        String script = null;
        String scriptLang = null;
        Map<String, Object> scriptParams = null;
        boolean keyed = false;
        boolean assumeSorted = false;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                if ("field".equals(currentFieldName)) {
                    field = parser.text();
                    continue;
                }
                if ("script".equals(currentFieldName)) {
                    script = parser.text();
                    continue;
                }
                if ("lang".equals(currentFieldName)) {
                    scriptLang = parser.text();
                    continue;
                }
                throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + aggregationName + "]: [" + currentFieldName + "].");
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if ("ranges".equals(currentFieldName)) {
                    ranges = new ArrayList<RangeAggregator.Range>();
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        double from = Double.NEGATIVE_INFINITY;
                        String fromAsStr = null;
                        double to = Double.POSITIVE_INFINITY;
                        String toAsStr = null;
                        String key = null;
                        String mask = null;
                        String toOrFromOrMaskOrKey = null;
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            if (token == XContentParser.Token.FIELD_NAME) {
                                toOrFromOrMaskOrKey = parser.currentName();
                                continue;
                            }
                            if (token == XContentParser.Token.VALUE_NUMBER) {
                                if ("from".equals(toOrFromOrMaskOrKey)) {
                                    from = parser.doubleValue();
                                    continue;
                                }
                                if (!"to".equals(toOrFromOrMaskOrKey)) continue;
                                to = parser.doubleValue();
                                continue;
                            }
                            if (token != XContentParser.Token.VALUE_STRING) continue;
                            if ("from".equals(toOrFromOrMaskOrKey)) {
                                fromAsStr = parser.text();
                                continue;
                            }
                            if ("to".equals(toOrFromOrMaskOrKey)) {
                                toAsStr = parser.text();
                                continue;
                            }
                            if ("key".equals(toOrFromOrMaskOrKey)) {
                                key = parser.text();
                                continue;
                            }
                            if (!"mask".equals(toOrFromOrMaskOrKey)) continue;
                            mask = parser.text();
                        }
                        RangeAggregator.Range range = new RangeAggregator.Range(key, from, fromAsStr, to, toAsStr);
                        if (mask != null) {
                            IpRangeParser.parseMaskRange(mask, range, aggregationName, context);
                        }
                        ranges.add(range);
                    }
                    continue;
                }
                throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + aggregationName + "]: [" + currentFieldName + "].");
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if ("params".equals(currentFieldName)) {
                    scriptParams = parser.map();
                    continue;
                }
                throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + aggregationName + "]: [" + currentFieldName + "].");
            }
            if (token == XContentParser.Token.VALUE_BOOLEAN) {
                if ("keyed".equals(currentFieldName)) {
                    keyed = parser.booleanValue();
                    continue;
                }
                if ("script_values_sorted".equals(currentFieldName) || "scriptValuesSorted".equals(currentFieldName)) {
                    assumeSorted = parser.booleanValue();
                    continue;
                }
                throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + aggregationName + "]: [" + currentFieldName + "].");
            }
            throw new SearchParseException(context, "Unexpected token " + (Object)((Object)token) + " in [" + aggregationName + "].");
        }
        if (ranges == null) {
            throw new SearchParseException(context, "Missing [ranges] in ranges aggregator [" + aggregationName + "]");
        }
        if (script != null) {
            config.script(context.scriptService().search(context.lookup(), scriptLang, script, scriptParams));
        }
        if (!assumeSorted) {
            config.ensureSorted(true);
        }
        config.formatter(ValueFormatter.IPv4);
        config.parser(ValueParser.IPv4);
        if (field == null) {
            return new RangeAggregator.Factory(aggregationName, config, InternalIPv4Range.FACTORY, ranges, keyed);
        }
        FieldMapper mapper = context.smartNameFieldMapper(field);
        if (mapper == null) {
            config.unmapped(true);
            return new RangeAggregator.Factory(aggregationName, config, InternalIPv4Range.FACTORY, ranges, keyed);
        }
        if (!(mapper instanceof IpFieldMapper)) {
            throw new AggregationExecutionException("ip_range aggregation can only be applied to ip fields which is not the case with field [" + field + "]");
        }
        Object indexFieldData = context.fieldData().getForField(mapper);
        config.fieldContext(new FieldContext(field, (IndexFieldData<?>)indexFieldData));
        return new RangeAggregator.Factory(aggregationName, config, InternalIPv4Range.FACTORY, ranges, keyed);
    }

    private static void parseMaskRange(String cidr, RangeAggregator.Range range, String aggregationName, SearchContext ctx) {
        long[] fromTo = IPv4RangeBuilder.cidrMaskToMinMax(cidr);
        if (fromTo == null) {
            throw new SearchParseException(ctx, "invalid CIDR mask [" + cidr + "] in aggregation [" + aggregationName + "]");
        }
        range.from = fromTo[0] < 0L ? Double.NEGATIVE_INFINITY : (double)fromTo[0];
        double d = range.to = fromTo[1] < 0L ? Double.POSITIVE_INFINITY : (double)fromTo[1];
        if (range.key == null) {
            range.key = cidr;
        }
    }
}

