/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.FilterBuilder;

public abstract class FacetBuilder
implements ToXContent {
    protected final String name;
    protected FilterBuilder facetFilter;
    protected Boolean global;
    protected String nested;
    protected Mode mode;

    protected FacetBuilder(String name) {
        this.name = name;
    }

    public FacetBuilder facetFilter(FilterBuilder filter) {
        this.facetFilter = filter;
        return this;
    }

    public FacetBuilder nested(String nested) {
        this.nested = nested;
        return this;
    }

    public FacetBuilder global(boolean global) {
        this.global = global;
        return this;
    }

    public FacetBuilder mode(Mode mode) {
        this.mode = mode;
        return this;
    }

    protected void addFilterFacetAndGlobal(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.facetFilter != null) {
            builder.field("facet_filter");
            this.facetFilter.toXContent(builder, params);
        }
        if (this.nested != null) {
            builder.field("nested", this.nested);
        }
        if (this.global != null) {
            builder.field("global", (Object)this.global);
        }
        if (this.mode != null) {
            builder.field("mode", this.mode.toString());
        }
    }

    public static enum Mode {
        COLLECTOR{

            @Override
            public String toString() {
                return "collector";
            }
        }
        ,
        POST{

            @Override
            public String toString() {
                return "post";
            }
        };


        public abstract String toString();
    }
}

