/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.datehistogram;

import java.util.Comparator;
import java.util.List;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.search.facet.Facet;

public interface DateHistogramFacet
extends Facet,
Iterable<Entry> {
    public static final String TYPE = "date_histogram";

    public List<? extends Entry> getEntries();

    public static interface Entry {
        public long getTime();

        public long getCount();

        public long getTotalCount();

        public double getTotal();

        public double getMean();

        public double getMin();

        public double getMax();
    }

    public static enum ComparatorType {
        TIME(0, "time", new Comparator<Entry>(){

            @Override
            public int compare(Entry o1, Entry o2) {
                if (o1 == null) {
                    if (o2 == null) {
                        return 0;
                    }
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                return o1.getTime() < o2.getTime() ? -1 : (o1.getTime() == o2.getTime() ? 0 : 1);
            }
        }),
        COUNT(1, "count", new Comparator<Entry>(){

            @Override
            public int compare(Entry o1, Entry o2) {
                if (o1 == null) {
                    if (o2 == null) {
                        return 0;
                    }
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                return o1.getCount() < o2.getCount() ? -1 : (o1.getCount() == o2.getCount() ? 0 : 1);
            }
        }),
        TOTAL(2, "total", new Comparator<Entry>(){

            @Override
            public int compare(Entry o1, Entry o2) {
                if (o1 == null) {
                    if (o2 == null) {
                        return 0;
                    }
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                return o1.getTotal() < o2.getTotal() ? -1 : (o1.getTotal() == o2.getTotal() ? 0 : 1);
            }
        });

        private final byte id;
        private final String description;
        private final Comparator<Entry> comparator;

        private ComparatorType(byte id, String description, Comparator<Entry> comparator) {
            this.id = id;
            this.description = description;
            this.comparator = comparator;
        }

        public byte id() {
            return this.id;
        }

        public String description() {
            return this.description;
        }

        public Comparator<Entry> comparator() {
            return this.comparator;
        }

        public static ComparatorType fromId(byte id) {
            if (id == 0) {
                return TIME;
            }
            if (id == 1) {
                return COUNT;
            }
            if (id == 2) {
                return TOTAL;
            }
            throw new ElasticsearchIllegalArgumentException("No type argument match for histogram comparator [" + id + "]");
        }

        public static ComparatorType fromString(String type) {
            if ("time".equals(type)) {
                return TIME;
            }
            if ("count".equals(type)) {
                return COUNT;
            }
            if ("total".equals(type)) {
                return TOTAL;
            }
            throw new ElasticsearchIllegalArgumentException("No type argument match for histogram comparator [" + type + "]");
        }
    }
}

