/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class MailDateFormat
extends SimpleDateFormat {
    private static final long serialVersionUID = -8148227605210628779L;

    public MailDateFormat() {
        super("EEE, d MMM yyyy HH:mm:ss Z (z)", Locale.US);
    }

    public StringBuffer format(Date date, StringBuffer buffer, FieldPosition position) {
        return super.format(date, buffer, position);
    }

    public Date parse(String string, ParsePosition position) {
        MailDateParser parser = new MailDateParser(string, position);
        try {
            return parser.parse(this.isLenient());
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setCalendar(Calendar calendar) {
        throw new UnsupportedOperationException();
    }

    public void setNumberFormat(NumberFormat format) {
        throw new UnsupportedOperationException();
    }

    class MailDateParser {
        static final String whitespace = " \t\r\n";
        int current;
        int endOffset;
        String source;
        ParsePosition pos;

        public MailDateParser(String source, ParsePosition pos) {
            this.source = source;
            this.pos = pos;
            this.current = pos.getIndex();
            this.endOffset = source.length();
        }

        public Date parse(boolean lenient) throws ParseException {
            this.locateNumeric();
            int day = this.parseNumber(1, 2);
            this.skipDateDelimiter();
            int month = this.parseMonth();
            this.skipDateDelimiter();
            int year = this.parseYear();
            this.skipRequiredWhiteSpace();
            int hour = this.parseNumber(1, 2);
            this.skipRequiredChar(':');
            int minutes = this.parseNumber(2, 2);
            int seconds = 0;
            if (this.skipOptionalChar(':')) {
                seconds = this.parseNumber(2, 2);
            }
            this.skipWhiteSpace();
            int offset = this.parseTimeZone();
            this.pos.setIndex(this.current);
            GregorianCalendar greg = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
            greg.setLenient(lenient);
            greg.set(year, month, day, hour, minutes, seconds);
            ((Calendar)greg).add(12, -offset);
            return greg.getTime();
        }

        private void skipRequiredChar(char ch) throws ParseException {
            if (this.current >= this.endOffset) {
                this.parseError("Delimiter '" + ch + "' expected");
            }
            if (this.source.charAt(this.current) != ch) {
                this.parseError("Delimiter '" + ch + "' expected");
            }
            ++this.current;
        }

        private boolean skipOptionalChar(char ch) {
            if (this.current >= this.endOffset) {
                return false;
            }
            if (this.source.charAt(this.current) != ch) {
                return false;
            }
            ++this.current;
            return true;
        }

        private void skipWhiteSpace() {
            while (this.current < this.endOffset) {
                if (whitespace.indexOf(this.source.charAt(this.current)) < 0) {
                    return;
                }
                ++this.current;
            }
        }

        private void skipNonWhiteSpace() {
            while (this.current < this.endOffset) {
                if (whitespace.indexOf(this.source.charAt(this.current)) >= 0) {
                    return;
                }
                ++this.current;
            }
        }

        private void skipRequiredWhiteSpace() throws ParseException {
            int start = this.current;
            while (this.current < this.endOffset) {
                if (whitespace.indexOf(this.source.charAt(this.current)) < 0) {
                    if (start == this.current) {
                        this.parseError("White space character expected");
                    }
                    return;
                }
                ++this.current;
            }
            if (start == this.current) {
                this.parseError("White space character expected");
            }
        }

        private void parseError(String message) throws ParseException {
            this.pos.setErrorIndex(this.current);
            throw new ParseException(message, this.current);
        }

        private void locateNumeric() throws ParseException {
            while (this.current < this.endOffset) {
                if (Character.isDigit(this.source.charAt(this.current))) {
                    return;
                }
                ++this.current;
            }
            this.parseError("Number field expected");
        }

        private int parseNumber(int minDigits, int maxDigits) throws ParseException {
            char ch;
            int start = this.current;
            int accumulator = 0;
            while (this.current < this.endOffset && Character.isDigit(ch = this.source.charAt(this.current))) {
                accumulator = accumulator * 10 + Character.digit(ch, 10);
                ++this.current;
            }
            int fieldLength = this.current - start;
            if (fieldLength < minDigits || fieldLength > maxDigits) {
                this.parseError("Invalid number field");
            }
            return accumulator;
        }

        private void skipDateDelimiter() throws ParseException {
            if (this.current >= this.endOffset) {
                this.parseError("Invalid date field delimiter");
            }
            if (this.source.charAt(this.current) == '-') {
                ++this.current;
            } else {
                this.skipRequiredWhiteSpace();
            }
        }

        private int parseMonth() throws ParseException {
            if (this.endOffset - this.current < 3) {
                this.parseError("Invalid month");
            }
            int monthOffset = 0;
            String month = this.source.substring(this.current, this.current + 3).toLowerCase();
            if (month.equals("jan")) {
                monthOffset = 0;
            } else if (month.equals("feb")) {
                monthOffset = 1;
            } else if (month.equals("mar")) {
                monthOffset = 2;
            } else if (month.equals("apr")) {
                monthOffset = 3;
            } else if (month.equals("may")) {
                monthOffset = 4;
            } else if (month.equals("jun")) {
                monthOffset = 5;
            } else if (month.equals("jul")) {
                monthOffset = 6;
            } else if (month.equals("aug")) {
                monthOffset = 7;
            } else if (month.equals("sep")) {
                monthOffset = 8;
            } else if (month.equals("oct")) {
                monthOffset = 9;
            } else if (month.equals("nov")) {
                monthOffset = 10;
            } else if (month.equals("dec")) {
                monthOffset = 11;
            } else {
                this.parseError("Invalid month");
            }
            this.current += 3;
            return monthOffset;
        }

        private int parseYear() throws ParseException {
            int year = this.parseNumber(2, 4);
            if (year < 50) {
                year += 2000;
            } else if (year < 100) {
                year += 1990;
            }
            return year;
        }

        private int parseTimeZone() throws ParseException {
            char sign;
            if (this.current >= this.endOffset) {
                this.parseError("Missing time zone");
            }
            if ((sign = this.source.charAt(this.current)) == '-' || sign == '+') {
                ++this.current;
                int zoneInfo = this.parseNumber(4, 4);
                int offset = zoneInfo / 100 * 60 + zoneInfo % 100;
                if (sign == '-') {
                    offset = -offset;
                }
                return offset;
            }
            int start = this.current;
            this.skipNonWhiteSpace();
            String name = this.source.substring(start, this.current).toUpperCase();
            if (name.length() == 1) {
                return this.militaryZoneOffset(name);
            }
            if (name.length() <= 3) {
                return this.namedZoneOffset(name);
            }
            this.parseError("Invalid time zone");
            return 0;
        }

        private int namedZoneOffset(String name) throws ParseException {
            if (name.equals("UT")) {
                return 0;
            }
            if (name.equals("GMT")) {
                return 0;
            }
            if (name.equals("EST")) {
                return -300;
            }
            if (name.equals("EDT")) {
                return -240;
            }
            if (name.equals("CST")) {
                return -360;
            }
            if (name.equals("CDT")) {
                return -300;
            }
            if (name.equals("MST")) {
                return -420;
            }
            if (name.equals("MDT")) {
                return -360;
            }
            if (name.equals("PST")) {
                return -480;
            }
            if (name.equals("PDT")) {
                return -420;
            }
            this.parseError("Invalid time zone");
            return 0;
        }

        private int militaryZoneOffset(String name) throws ParseException {
            switch (Character.toUpperCase(name.charAt(0))) {
                case 'A': {
                    return 60;
                }
                case 'B': {
                    return 120;
                }
                case 'C': {
                    return 180;
                }
                case 'D': {
                    return 240;
                }
                case 'E': {
                    return 300;
                }
                case 'F': {
                    return 360;
                }
                case 'G': {
                    return 420;
                }
                case 'H': {
                    return 480;
                }
                case 'I': {
                    return 540;
                }
                case 'K': {
                    return 600;
                }
                case 'L': {
                    return 660;
                }
                case 'M': {
                    return 720;
                }
                case 'N': {
                    return -60;
                }
                case 'O': {
                    return -120;
                }
                case 'P': {
                    return -180;
                }
                case 'Q': {
                    return -240;
                }
                case 'R': {
                    return -300;
                }
                case 'S': {
                    return -360;
                }
                case 'T': {
                    return -420;
                }
                case 'U': {
                    return -480;
                }
                case 'V': {
                    return -540;
                }
                case 'W': {
                    return -600;
                }
                case 'X': {
                    return -660;
                }
                case 'Y': {
                    return -720;
                }
                case 'Z': {
                    return 0;
                }
            }
            this.parseError("Invalid time zone");
            return 0;
        }
    }
}

