/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.crs;

import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.cs.DefaultAffineCS;
import org.apache.sis.referencing.cs.DefaultCartesianCS;
import org.apache.sis.referencing.cs.DefaultCylindricalCS;
import org.apache.sis.referencing.cs.DefaultLinearCS;
import org.apache.sis.referencing.cs.DefaultPolarCS;
import org.apache.sis.referencing.cs.DefaultSphericalCS;
import org.apache.sis.referencing.cs.DefaultUserDefinedCS;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.datum.EngineeringDatum;

@XmlType(name="EngineeringCRSType", propOrder={"coordinateSystem", "datum"})
@XmlRootElement(name="EngineeringCRS")
public class DefaultEngineeringCRS
extends AbstractCRS
implements EngineeringCRS {
    private static final long serialVersionUID = 6695541732063382701L;
    private EngineeringDatum datum;

    public DefaultEngineeringCRS(Map<String, ?> map, EngineeringDatum engineeringDatum, CoordinateSystem coordinateSystem) {
        super(map, coordinateSystem);
        ArgumentChecks.ensureNonNull("datum", engineeringDatum);
        this.datum = engineeringDatum;
    }

    protected DefaultEngineeringCRS(EngineeringCRS engineeringCRS) {
        super((CoordinateReferenceSystem)engineeringCRS);
        this.datum = engineeringCRS.getDatum();
    }

    public static DefaultEngineeringCRS castOrCopy(EngineeringCRS engineeringCRS) {
        return engineeringCRS == null || engineeringCRS instanceof DefaultEngineeringCRS ? (DefaultEngineeringCRS)engineeringCRS : new DefaultEngineeringCRS(engineeringCRS);
    }

    public Class<? extends EngineeringCRS> getInterface() {
        return EngineeringCRS.class;
    }

    @XmlElement(name="engineeringDatum", required=true)
    public EngineeringDatum getDatum() {
        return this.datum;
    }

    @Override
    @XmlElements(value={@XmlElement(name="cartesianCS", type=DefaultCartesianCS.class), @XmlElement(name="affineCS", type=DefaultAffineCS.class), @XmlElement(name="cylindricalCS", type=DefaultCylindricalCS.class), @XmlElement(name="linearCS", type=DefaultLinearCS.class), @XmlElement(name="polarCS", type=DefaultPolarCS.class), @XmlElement(name="sphericalCS", type=DefaultSphericalCS.class), @XmlElement(name="userDefinedCS", type=DefaultUserDefinedCS.class)})
    public CoordinateSystem getCoordinateSystem() {
        return super.getCoordinateSystem();
    }

    @Override
    public DefaultEngineeringCRS forConvention(AxesConvention axesConvention) {
        return (DefaultEngineeringCRS)super.forConvention(axesConvention);
    }

    @Override
    final AbstractCRS createSameType(Map<String, ?> map, CoordinateSystem coordinateSystem) {
        return new DefaultEngineeringCRS(map, this.datum, coordinateSystem);
    }

    @Override
    protected String formatTo(Formatter formatter) {
        super.formatTo(formatter);
        return formatter.getConvention().majorVersion() == 1 ? "Local_CS" : (DefaultEngineeringCRS.isBaseCRS(formatter) ? "BaseEngCRS" : formatter.shortOrLong("EngCRS", "EngineeringCRS"));
    }

    private DefaultEngineeringCRS() {
    }

    private void setDatum(EngineeringDatum engineeringDatum) {
        if (this.datum == null) {
            this.datum = engineeringDatum;
        } else {
            MetadataUtilities.propertyAlreadySet(DefaultEngineeringCRS.class, "setDatum", "engineeringDatum");
        }
    }

    private void setCoordinateSystem(CoordinateSystem coordinateSystem) {
        this.setCoordinateSystem(null, coordinateSystem);
    }
}

