/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.projection;

import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.referencing.operation.projection.Initializer;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.apache.sis.referencing.operation.projection.ProjectionException;

abstract class ConformalProjection
extends NormalizedProjection {
    private static final long serialVersionUID = -292755890184138414L;
    static final double ECCENTRICITY_THRESHOLD = 0.16;
    private final boolean useIterations;
    private final double c2\u03c7;
    private final double c4\u03c7;
    private final double c6\u03c7;
    private final double c8\u03c7;

    ConformalProjection(Initializer initializer) {
        super(initializer);
        this.useIterations = this.eccentricity >= 0.16;
        double d = this.eccentricitySquared;
        double d2 = d * d;
        double d3 = d * d2;
        double d4 = d2 * d2;
        this.c2\u03c7 = -0.036210317460317464 * d4 + 0.025 * d3 + 0.20833333333333334 * d2 + 0.5 * d;
        this.c4\u03c7 = 0.03467261904761905 * d4 + 0.24166666666666667 * d3 + 0.2916666666666667 * d2;
        this.c6\u03c7 = 0.2892857142857143 * d4 + 0.23333333333333334 * d3;
        this.c8\u03c7 = 0.21225198412698412 * d4;
    }

    ConformalProjection(ConformalProjection conformalProjection) {
        super(conformalProjection);
        this.useIterations = conformalProjection.useIterations;
        this.c2\u03c7 = conformalProjection.c2\u03c7;
        this.c4\u03c7 = conformalProjection.c4\u03c7;
        this.c6\u03c7 = conformalProjection.c6\u03c7;
        this.c8\u03c7 = conformalProjection.c8\u03c7;
    }

    final double \u03c6(double d) throws ProjectionException {
        double d2 = 1.5707963267948966 - 2.0 * Math.atan(d);
        double d3 = Math.sin(2.0 * d2);
        double d4 = Math.cos(2.0 * d2);
        d2 += d3 * (this.c2\u03c7 + d4 * (this.c4\u03c7 + d4 * (this.c6\u03c7 + d4 * this.c8\u03c7)));
        if (!this.useIterations) {
            return d2;
        }
        double d5 = 0.5 * this.eccentricity;
        for (int i = 0; i < 18; ++i) {
            double d6 = this.eccentricity * Math.sin(d2);
            double d7 = d2 - (d2 = 1.5707963267948966 - 2.0 * Math.atan(d * Math.pow((1.0 - d6) / (1.0 + d6), d5)));
            if (Math.abs(d7) > 3.926676682852614E-10) continue;
            return d2;
        }
        throw new ProjectionException(Resources.format((short)46));
    }

    final double exp\u03a8(double d, double d2) {
        return Math.tan(0.7853981633974483 + 0.5 * d) * Math.pow((1.0 - d2) / (1.0 + d2), 0.5 * this.eccentricity);
    }

    final double dy_d\u03c6(double d, double d2) {
        return 1.0 / d2 - this.eccentricitySquared * d2 / (1.0 - this.eccentricitySquared * (d * d));
    }
}

