/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ProtoUtils;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequestResponse;
import org.apache.kafka.common.utils.CollectionUtils;

public class OffsetCommitResponse
extends AbstractRequestResponse {
    public static Schema curSchema = ProtoUtils.currentResponseSchema(ApiKeys.OFFSET_COMMIT.id);
    private static String RESPONSES_KEY_NAME = "responses";
    private static String TOPIC_KEY_NAME = "topic";
    private static String PARTITIONS_KEY_NAME = "partition_responses";
    private static String PARTITION_KEY_NAME = "partition";
    private static String ERROR_CODE_KEY_NAME = "error_code";
    private final Map<TopicPartition, Short> responseData;

    public OffsetCommitResponse(Map<TopicPartition, Short> responseData) {
        super(new Struct(curSchema));
        Map<String, Map<Integer, Short>> topicsData = CollectionUtils.groupDataByTopic(responseData);
        ArrayList<Struct> topicArray = new ArrayList<Struct>();
        for (Map.Entry<String, Map<Integer, Short>> entries : topicsData.entrySet()) {
            Struct topicData = this.struct.instance(RESPONSES_KEY_NAME);
            topicData.set(TOPIC_KEY_NAME, (Object)entries.getKey());
            ArrayList<Struct> partitionArray = new ArrayList<Struct>();
            for (Map.Entry<Integer, Short> partitionEntry : entries.getValue().entrySet()) {
                Struct partitionData = topicData.instance(PARTITIONS_KEY_NAME);
                partitionData.set(PARTITION_KEY_NAME, (Object)partitionEntry.getKey());
                partitionData.set(ERROR_CODE_KEY_NAME, (Object)partitionEntry.getValue());
                partitionArray.add(partitionData);
            }
            topicData.set(PARTITIONS_KEY_NAME, (Object)partitionArray.toArray());
            topicArray.add(topicData);
        }
        this.struct.set(RESPONSES_KEY_NAME, (Object)topicArray.toArray());
        this.responseData = responseData;
    }

    public OffsetCommitResponse(Struct struct) {
        super(struct);
        this.responseData = new HashMap<TopicPartition, Short>();
        for (Object topicResponseObj : struct.getArray(RESPONSES_KEY_NAME)) {
            Struct topicResponse = (Struct)topicResponseObj;
            String topic = topicResponse.getString(TOPIC_KEY_NAME);
            for (Object partitionResponseObj : topicResponse.getArray(PARTITIONS_KEY_NAME)) {
                Struct partitionResponse = (Struct)partitionResponseObj;
                int partition = partitionResponse.getInt(PARTITION_KEY_NAME);
                short errorCode = partitionResponse.getShort(ERROR_CODE_KEY_NAME);
                this.responseData.put(new TopicPartition(topic, partition), errorCode);
            }
        }
    }

    public Map<TopicPartition, Short> responseData() {
        return this.responseData;
    }

    public static OffsetCommitResponse parse(ByteBuffer buffer) {
        return new OffsetCommitResponse((Struct)curSchema.read(buffer));
    }
}

