/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.DataElement;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.DataElementData;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.DataElementHash;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.IntermediateNodeObject;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.LeafNodeObject;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.NodeObject;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.ObjectGroupData;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.ObjectGroupDeclarations;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.ObjectGroupMetadataDeclarations;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.ObjectGroupObjectData;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.ObjectGroupObjectDeclare;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObject;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.BinaryItem;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.CellIDArray;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.Compact64bitInt;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.DataElementType;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.DataNodeObjectData;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.ExGUIDArray;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.ExGuid;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.util.ByteUtil;

public class ObjectGroupDataElementData
extends DataElementData {
    public DataElementHash dataElementHash = null;
    public ObjectGroupDeclarations objectGroupDeclarations = new ObjectGroupDeclarations();
    public ObjectGroupMetadataDeclarations objectMetadataDeclaration = null;
    public ObjectGroupData objectGroupData = new ObjectGroupData();

    @Override
    public List<Byte> serializeToByteList() throws TikaException, IOException {
        ArrayList<Byte> result = new ArrayList<Byte>();
        if (this.dataElementHash != null) {
            result.addAll(this.dataElementHash.serializeToByteList());
        }
        result.addAll(this.objectGroupDeclarations.serializeToByteList());
        if (this.objectMetadataDeclaration != null) {
            result.addAll(this.objectMetadataDeclaration.serializeToByteList());
        }
        result.addAll(this.objectGroupData.serializeToByteList());
        return result;
    }

    @Override
    public int deserializeDataElementDataFromByteArray(byte[] byteArray, int startIndex) throws TikaException, IOException {
        AtomicInteger index = new AtomicInteger(startIndex);
        AtomicReference dataElementHash = new AtomicReference();
        if (StreamObject.tryGetCurrent(byteArray, index, dataElementHash, DataElementHash.class)) {
            this.dataElementHash = (DataElementHash)dataElementHash.get();
        }
        this.objectGroupDeclarations = StreamObject.getCurrent(byteArray, index, ObjectGroupDeclarations.class);
        AtomicReference<ObjectGroupMetadataDeclarations> objectMetadataDeclaration = new AtomicReference<ObjectGroupMetadataDeclarations>(new ObjectGroupMetadataDeclarations());
        if (StreamObject.tryGetCurrent(byteArray, index, objectMetadataDeclaration, ObjectGroupMetadataDeclarations.class)) {
            this.objectMetadataDeclaration = objectMetadataDeclaration.get();
        }
        this.objectGroupData = StreamObject.getCurrent(byteArray, index, ObjectGroupData.class);
        return index.get() - startIndex;
    }

    public static class Builder {
        public List<DataElement> build(NodeObject node) throws TikaException, IOException {
            ArrayList<DataElement> dataElements = new ArrayList<DataElement>();
            this.traverseNodeObject(node, dataElements);
            return dataElements;
        }

        private void traverseNodeObject(NodeObject node, List<DataElement> dataElements) throws TikaException, IOException {
            if (node instanceof IntermediateNodeObject) {
                IntermediateNodeObject intermediateNodeObject = (IntermediateNodeObject)node;
                ObjectGroupDataElementData data = new ObjectGroupDataElementData();
                data.objectGroupDeclarations.objectDeclarationList.add(this.createObjectDeclare(node));
                data.objectGroupData.objectGroupObjectDataList.add(this.createObjectData((IntermediateNodeObject)node));
                dataElements.add(new DataElement(DataElementType.ObjectGroupDataElementData, data));
                for (LeafNodeObject child : intermediateNodeObject.intermediateNodeObjectList) {
                    this.traverseNodeObject(child, dataElements);
                }
            } else if (node instanceof LeafNodeObject) {
                LeafNodeObject intermediateNode = (LeafNodeObject)node;
                ObjectGroupDataElementData data = new ObjectGroupDataElementData();
                data.objectGroupDeclarations.objectDeclarationList.add(this.createObjectDeclare(node));
                data.objectGroupData.objectGroupObjectDataList.add(this.createObjectData(intermediateNode));
                if (intermediateNode.dataNodeObjectData != null) {
                    data.objectGroupDeclarations.objectDeclarationList.add(this.createObjectDeclare(intermediateNode.dataNodeObjectData));
                    data.objectGroupData.objectGroupObjectDataList.add(this.createObjectData(intermediateNode.dataNodeObjectData));
                    dataElements.add(new DataElement(DataElementType.ObjectGroupDataElementData, data));
                    return;
                }
                if (intermediateNode.dataNodeObjectData == null && intermediateNode.intermediateNodeObjectList != null) {
                    dataElements.add(new DataElement(DataElementType.ObjectGroupDataElementData, data));
                    for (LeafNodeObject child : intermediateNode.intermediateNodeObjectList) {
                        this.traverseNodeObject(child, dataElements);
                    }
                    return;
                }
                throw new TikaException("The DataNodeObjectData and IntermediateNodeObjectList properties in LeafNodeObjectData type cannot be null in the same time.");
            }
        }

        private ObjectGroupObjectDeclare createObjectDeclare(NodeObject node) throws TikaException {
            ObjectGroupObjectDeclare objectGroupObjectDeclare = new ObjectGroupObjectDeclare();
            objectGroupObjectDeclare.objectExtendedGUID = node.exGuid;
            objectGroupObjectDeclare.objectPartitionID = new Compact64bitInt(1L);
            objectGroupObjectDeclare.cellReferencesCount = new Compact64bitInt(0L);
            objectGroupObjectDeclare.objectReferencesCount = new Compact64bitInt(0L);
            objectGroupObjectDeclare.objectDataSize = new Compact64bitInt(node.getContent().size());
            return objectGroupObjectDeclare;
        }

        private ObjectGroupObjectDeclare createObjectDeclare(DataNodeObjectData node) {
            ObjectGroupObjectDeclare objectGroupObjectDeclare = new ObjectGroupObjectDeclare();
            objectGroupObjectDeclare.objectExtendedGUID = node.exGuid;
            objectGroupObjectDeclare.objectPartitionID = new Compact64bitInt(1L);
            objectGroupObjectDeclare.cellReferencesCount = new Compact64bitInt(0L);
            objectGroupObjectDeclare.objectReferencesCount = new Compact64bitInt(1L);
            objectGroupObjectDeclare.objectDataSize = new Compact64bitInt(node.objectData.length);
            return objectGroupObjectDeclare;
        }

        private ObjectGroupObjectData createObjectData(IntermediateNodeObject node) throws TikaException, IOException {
            ObjectGroupObjectData objectData = new ObjectGroupObjectData();
            objectData.cellIDArray = new CellIDArray(0L, null);
            ArrayList<ExGuid> extendedGuidList = new ArrayList<ExGuid>();
            for (LeafNodeObject child : node.intermediateNodeObjectList) {
                extendedGuidList.add(child.exGuid);
            }
            objectData.objectExGUIDArray = new ExGUIDArray(extendedGuidList);
            objectData.data = new BinaryItem(node.serializeToByteList());
            return objectData;
        }

        private ObjectGroupObjectData createObjectData(LeafNodeObject node) throws TikaException, IOException {
            ObjectGroupObjectData objectData = new ObjectGroupObjectData();
            objectData.cellIDArray = new CellIDArray(0L, null);
            ArrayList<ExGuid> extendedGuidList = new ArrayList<ExGuid>();
            if (node.dataNodeObjectData != null) {
                extendedGuidList.add(node.dataNodeObjectData.exGuid);
            } else if (node.intermediateNodeObjectList != null) {
                for (LeafNodeObject child : node.intermediateNodeObjectList) {
                    extendedGuidList.add(child.exGuid);
                }
            }
            objectData.objectExGUIDArray = new ExGUIDArray(extendedGuidList);
            objectData.data = new BinaryItem(node.serializeToByteList());
            return objectData;
        }

        private ObjectGroupObjectData createObjectData(DataNodeObjectData node) {
            ObjectGroupObjectData objectData = new ObjectGroupObjectData();
            objectData.cellIDArray = new CellIDArray(0L, null);
            objectData.objectExGUIDArray = new ExGUIDArray(new ArrayList<ExGuid>());
            objectData.data = new BinaryItem(ByteUtil.toListOfByte(node.objectData));
            return objectData;
        }
    }
}

