/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.apache.log4j.NDC;
import org.opensaml.BindingException;
import org.opensaml.SAMLConfig;
import org.opensaml.SAMLException;
import org.opensaml.SAMLRequest;
import org.opensaml.SAMLResponse;
import org.opensaml.SAMLSOAPBinding;
import org.opensaml.SOAPException;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public abstract class SOAPBinding
implements SAMLSOAPBinding {
    private static SAMLConfig config = SAMLConfig.instance();
    private Logger log = Logger.getLogger((String)SOAPBinding.class.getName());
    private Map soapHooks = Collections.synchronizedMap(new HashMap(4));

    public void addHook(SAMLSOAPBinding.SOAPHook sOAPHook) {
        this.addHook(sOAPHook, null);
    }

    public void addHook(SAMLSOAPBinding.SOAPHook sOAPHook, Object object) {
        this.soapHooks.put(sOAPHook, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element sendRequest(SAMLRequest sAMLRequest, Object object) throws SAMLException {
        NDC.push((String)"sendRequest");
        try {
            Document document = sAMLRequest.toDOM().getOwnerDocument();
            Element element = document.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "Envelope");
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://schemas.xmlsoap.org/soap/envelope/");
            Element element2 = document.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "Body");
            element.appendChild(element2);
            element2.appendChild(sAMLRequest.toDOM());
            if (document.getDocumentElement() == null) {
                document.appendChild(element);
            } else {
                document.replaceChild(element, document.getDocumentElement());
            }
            Object object2 = this.soapHooks.entrySet().iterator();
            while (object2.hasNext()) {
                Map.Entry entry = object2.next();
                if (((SAMLSOAPBinding.SOAPHook)entry.getKey()).outgoing(element, entry.getValue(), object)) continue;
                element2.removeChild(sAMLRequest.toDOM());
                this.log.warn((Object)"SOAP processing hook returned false, aborting outgoing request");
                throw new BindingException(SAMLException.REQUESTER, "SOAPBinding.sendRequest() SOAP processing hook returned false, aborted outgoing request");
            }
            object2 = element;
            return object2;
        }
        finally {
            NDC.pop();
        }
    }

    public SAMLResponse recvResponse(Element element, Object object) throws SAMLException {
        NDC.push((String)"recvResponse");
        try {
            Object object2;
            if (!XML.isElementNamed(element, "http://schemas.xmlsoap.org/soap/envelope/", "Envelope")) {
                throw new BindingException("SOAPBinding.recvResponse() detected an incompatible or missing SOAP envelope");
            }
            Object object3 = this.soapHooks.entrySet().iterator();
            while (object3.hasNext()) {
                object2 = object3.next();
                if (((SAMLSOAPBinding.SOAPHook)object2.getKey()).incoming(element, object2.getValue(), object)) continue;
                this.log.warn((Object)"SOAP processing hook returned false, aborting incoming response");
                throw new BindingException(SAMLException.REQUESTER, "SOAPBinding.recvResponse() SOAP processing hook returned false, aborted incoming response");
            }
            object3 = XML.getFirstChildElement(element);
            if (XML.isElementNamed((Element)object3, "http://schemas.xmlsoap.org/soap/envelope/", "Header")) {
                if (this.soapHooks.isEmpty()) {
                    object2 = XML.getFirstChildElement((Node)object3);
                    while (object2 != null) {
                        if (object2.getAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "mustUnderstand") != null && object2.getAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "mustUnderstand").equals("1")) {
                            throw new SOAPException(SOAPException.MUSTUNDERSTAND, "SOAPBinding.recvResponse() detected a mandatory SOAP header");
                        }
                        object2 = XML.getNextSiblingElement((Node)object2);
                    }
                }
                object3 = XML.getNextSiblingElement((Node)object3);
            }
            if (object3 != null && (object3 = XML.getFirstChildElement((Node)object3)) != null) {
                if (XML.isElementNamed((Element)object3, "http://schemas.xmlsoap.org/soap/envelope/", "Fault")) {
                    object2 = object3.getElementsByTagNameNS(null, "faultstring");
                    String string = object2 != null && object2.getLength() > 0 ? object2.item(0).getFirstChild().getNodeValue() : "SAMLSOAPBinding.recvResponse() detected a SOAP fault";
                    object2 = object3.getElementsByTagNameNS(null, "faultstring");
                    if (object2 != null && object2.getLength() > 0) {
                        throw new SOAPException(XML.getQNameTextNode((Text)object2.item(0).getFirstChild()), string);
                    }
                    throw new SOAPException(SOAPException.SERVER, string);
                }
                object2 = new SAMLResponse((Element)object3);
                return object2;
            }
            throw new SOAPException(SOAPException.SERVER, "SOAPBinding.recvResponse() unable to find a SAML response or fault in SOAP body");
        }
        finally {
            NDC.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SAMLRequest recvRequest(Element element, Object object) throws SAMLException {
        NDC.push((String)"recvRequest");
        try {
            Map.Entry entry;
            if (!XML.isElementNamed(element, "http://schemas.xmlsoap.org/soap/envelope/", "Envelope")) {
                throw new SOAPException(SOAPException.VERSION, "SOAPBinding.recvRequest() detected an incompatible or missing SOAP envelope");
            }
            Object object2 = this.soapHooks.entrySet().iterator();
            while (object2.hasNext()) {
                entry = object2.next();
                if (((SAMLSOAPBinding.SOAPHook)entry.getKey()).incoming(element, entry.getValue(), object)) continue;
                this.log.warn((Object)"SOAP processing hook returned false, aborting incoming request");
                throw new BindingException(SAMLException.REQUESTER, "SOAPBinding.recvRequest() SOAP processing hook returned false, aborted incoming request");
            }
            object2 = XML.getFirstChildElement(element);
            if (XML.isElementNamed((Element)object2, "http://schemas.xmlsoap.org/soap/envelope/", "Header")) {
                if (this.soapHooks.isEmpty()) {
                    entry = XML.getFirstChildElement((Node)object2);
                    while (entry != null) {
                        if (entry.getAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "mustUnderstand").equals("1")) {
                            throw new SOAPException(SOAPException.MUSTUNDERSTAND, "SOAPBinding.recvRequest() detected a mandatory SOAP header");
                        }
                        entry = XML.getNextSiblingElement((Node)((Object)entry));
                    }
                }
                object2 = XML.getNextSiblingElement((Node)object2);
            }
            if (object2 != null) {
                object2 = XML.getFirstChildElement((Node)object2);
            }
            entry = new SAMLRequest((Element)object2);
            return entry;
        }
        finally {
            NDC.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element sendResponse(SAMLResponse sAMLResponse, SAMLException sAMLException, Object object) throws SAMLException {
        NDC.push((String)"sendResponse");
        try {
            Object object2;
            Object object3;
            Document document = sAMLException == null ? sAMLResponse.toDOM().getOwnerDocument() : XML.parserPool.newDocument();
            Element element = document.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "soap:Envelope");
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:soap", "http://schemas.xmlsoap.org/soap/envelope/");
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            if (document.getDocumentElement() == null) {
                document.appendChild(element);
            } else {
                document.replaceChild(element, document.getDocumentElement());
            }
            Element element2 = document.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "soap:Body");
            element.appendChild(element2);
            if (sAMLException != null) {
                object3 = document.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "soap:Fault");
                element2.appendChild((Node)object3);
                object2 = document.createElementNS(null, "faultcode");
                if (sAMLException instanceof SOAPException) {
                    Iterator iterator = sAMLException.getCodes();
                    if (iterator.hasNext()) {
                        object2.appendChild(document.createTextNode("soap:" + ((QName)iterator.next()).getLocalPart()));
                    } else {
                        object2.appendChild(document.createTextNode("soap:" + SOAPException.SERVER.getLocalPart()));
                    }
                } else {
                    object2.appendChild(document.createTextNode("soap:" + SOAPException.SERVER.getLocalPart()));
                }
                object3.appendChild((Node)object2);
                object2 = document.createElementNS(null, "faultstring");
                object3.appendChild((Node)object2).appendChild(document.createTextNode(sAMLException.getMessage()));
            } else {
                element2.appendChild(sAMLResponse.toDOM());
            }
            object3 = this.soapHooks.entrySet().iterator();
            while (object3.hasNext()) {
                object2 = (Map.Entry)object3.next();
                if (((SAMLSOAPBinding.SOAPHook)object2.getKey()).outgoing(element, object2.getValue(), object)) continue;
                element2.removeChild(sAMLResponse.toDOM());
                this.log.warn((Object)"SOAP processing hook returned false, aborting outgoing response");
                throw new BindingException("SOAPBinding.sendResponse() SOAP processing hook returned false, aborted outgoing response");
            }
            object3 = element;
            return object3;
        }
        finally {
            NDC.pop();
        }
    }
}

