/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.StringUtils;

public class SvnConfigFileReader {
    private File configDirectory;

    public File getConfigDirectory() {
        if (this.configDirectory == null) {
            this.configDirectory = Os.isFamily((String)"windows") ? new File(System.getProperty("user.home"), "Application Data/Subversion") : new File(System.getProperty("user.home"), ".subversion");
        }
        return this.configDirectory;
    }

    public void setConfigDirectory(File configDirectory) {
        this.configDirectory = configDirectory;
    }

    public String getProperty(String group, String propertyName) {
        List lines = this.getConfLines();
        boolean inGroup = false;
        Iterator i = lines.iterator();
        while (i.hasNext()) {
            String property;
            String line = ((String)i.next()).trim();
            if (!inGroup) {
                if (!("[" + group + "]").equals(line)) continue;
                inGroup = true;
                continue;
            }
            if (line.startsWith("[") && line.endsWith("]")) {
                return null;
            }
            if (line.startsWith("#") || line.indexOf(61) < 0 || !(property = line.substring(0, line.indexOf(61)).trim()).equals(propertyName)) continue;
            String value = line.substring(line.indexOf(61) + 1);
            return value.trim();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getConfLines() {
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader reader = null;
        try {
            if (this.getConfigDirectory().exists()) {
                String line;
                reader = new BufferedReader(new FileReader(new File(this.getConfigDirectory(), "config")));
                while ((line = reader.readLine()) != null) {
                    if (line.startsWith("#") || !StringUtils.isNotEmpty((String)line)) continue;
                    lines.add(line);
                }
            }
        }
        catch (IOException e) {
            lines.clear();
        }
        finally {
            IOUtil.close(reader);
            reader = null;
        }
        return lines;
    }
}

