/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.NoSuchElementException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FSMatchConstraint;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.impl.FSIteratorImplBase;
import org.apache.uima.cas.text.AnnotationFS;

class FilteredIterator<T extends FeatureStructure>
extends FSIteratorImplBase<T> {
    private FSIterator<T> it;
    private FSMatchConstraint cons;

    private FilteredIterator() {
    }

    FilteredIterator(FSIterator<T> it, FSMatchConstraint cons) {
        this();
        this.it = it;
        this.cons = cons;
        this.moveToFirst();
    }

    @Override
    public boolean isValid() {
        return this.it.isValid();
    }

    private void adjustForConstraintForward() {
        while (this.it.isValid() && !this.cons.match((FeatureStructure)this.it.get())) {
            this.it.moveToNext();
        }
    }

    private void adjustForConstraintBackward() {
        while (this.it.isValid() && !this.cons.match((FeatureStructure)this.it.get())) {
            this.it.moveToPrevious();
        }
    }

    @Override
    public void moveToFirst() {
        this.it.moveToFirst();
        this.adjustForConstraintForward();
    }

    @Override
    public void moveToLast() {
        this.it.moveToLast();
        this.adjustForConstraintBackward();
    }

    @Override
    public void moveToNext() {
        this.it.moveToNext();
        this.adjustForConstraintForward();
    }

    @Override
    public void moveToPrevious() {
        this.it.moveToPrevious();
        this.adjustForConstraintBackward();
    }

    @Override
    public T get() throws NoSuchElementException {
        return this.it.get();
    }

    @Override
    public FSIterator<T> copy() {
        return new FilteredIterator<T>(this.it.copy(), this.cons);
    }

    @Override
    public void moveTo(FeatureStructure fs) {
        this.it.moveTo(fs);
        this.adjustForConstraintForward();
    }

    @Override
    <TT extends AnnotationFS> void moveTo(int begin, int end) {
        ((FSIteratorImplBase)this.it).moveTo(begin, end);
        this.adjustForConstraintForward();
    }
}

