/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Objects;
import java.util.RandomAccess;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.collection.CheckedContainer;

public class UnmodifiableArrayList<E>
extends AbstractList<E>
implements RandomAccess,
CheckedContainer<E>,
Serializable {
    private static final long serialVersionUID = 13882164775184042L;
    final E[] array;

    protected UnmodifiableArrayList(E[] EArray) {
        this.array = Objects.requireNonNull(EArray);
    }

    public static <E> UnmodifiableArrayList<E> wrap(E[] EArray) {
        return EArray != null ? new UnmodifiableArrayList<E>(EArray) : null;
    }

    public static <E> UnmodifiableArrayList<E> wrap(E[] EArray, int n, int n2) {
        if (n == 0 && n2 == EArray.length) {
            return new UnmodifiableArrayList<E>(EArray);
        }
        return new SubList<E>(EArray, n, n2 - n);
    }

    @Override
    public Class<E> getElementType() {
        return this.array.getClass().getComponentType();
    }

    int lower() {
        return 0;
    }

    @Override
    public int size() {
        return this.array.length;
    }

    public final int arraySize() {
        return this.array.length;
    }

    @Override
    public E get(int n) {
        return this.array[n];
    }

    @Override
    public int indexOf(Object object) {
        int n = this.lower();
        int n2 = n + this.size();
        if (object == null) {
            for (int i = n; i < n2; ++i) {
                if (this.array[i] != null) continue;
                return i - n;
            }
        } else {
            for (int i = n; i < n2; ++i) {
                if (!object.equals(this.array[i])) continue;
                return i - n;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        int n = this.lower();
        int n2 = n + this.size();
        if (object == null) {
            while (--n2 >= n && this.array[n2] != null) {
            }
        } else {
            while (--n2 >= n && !object.equals(this.array[n2])) {
            }
        }
        return n2 - n;
    }

    @Override
    public boolean contains(Object object) {
        int n = this.lower();
        int n2 = n + this.size();
        if (object == null) {
            while (--n2 >= n) {
                if (this.array[n2] != null) continue;
                return true;
            }
        } else {
            while (--n2 >= n) {
                if (!object.equals(this.array[n2])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public UnmodifiableArrayList<E> subList(int n, int n2) throws IndexOutOfBoundsException {
        ArgumentChecks.ensureValidIndexRange(this.size(), n, n2);
        return new SubList<E>(this.array, n + this.lower(), n2 - n);
    }

    @Override
    public E[] toArray() {
        return (Object[])this.array.clone();
    }

    @Override
    public <T> T[] toArray(T[] objectArray) {
        int n = this.size();
        if (objectArray.length != n) {
            if (objectArray.length < n) {
                objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
            } else {
                objectArray[n] = null;
            }
        }
        System.arraycopy(this.array, this.lower(), objectArray, 0, n);
        return objectArray;
    }

    @Override
    public boolean equals(Object object) {
        if (object != this) {
            if (!(object instanceof UnmodifiableArrayList)) {
                return super.equals(object);
            }
            UnmodifiableArrayList unmodifiableArrayList = (UnmodifiableArrayList)object;
            int n = this.size();
            if (n != unmodifiableArrayList.size()) {
                return false;
            }
            int n2 = this.lower();
            int n3 = unmodifiableArrayList.lower();
            while (--n >= 0) {
                if (Objects.equals(this.array[n2++], unmodifiableArrayList.array[n3++])) continue;
                return false;
            }
        }
        return true;
    }

    private static final class SubList<E>
    extends UnmodifiableArrayList<E> {
        private static final long serialVersionUID = 33065197642139916L;
        private final int lower;
        private final int size;

        SubList(E[] EArray, int n, int n2) {
            super(EArray);
            this.lower = n;
            this.size = n2;
        }

        @Override
        int lower() {
            return this.lower;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public E get(int n) {
            ArgumentChecks.ensureValidIndex(this.size, n);
            return super.get(n + this.lower);
        }

        @Override
        public E[] toArray() {
            return Arrays.copyOfRange(this.array, this.lower, this.lower + this.size);
        }
    }
}

