/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.scopes.local;

import com.github.sommeri.less4j.utils.ArraysUtils;
import com.github.sommeri.less4j.utils.PubliclyCloneable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class KeyListStorage<M, T>
implements Cloneable {
    private LinkedList<Level<M, T>> levels = new LinkedList();
    private LinkedList<ListPlaceholder<M, T>> placeholders = new LinkedList();

    public void add(M key, T thing) {
        Level<M, T> lastLevel = this.getLastLevel();
        lastLevel.add(key, thing);
    }

    public void add(M key, List<T> thing) {
        Level<M, T> lastLevel = this.getLastLevel();
        lastLevel.add(key, thing);
    }

    public void add(ListPlaceholder<M, T> placeholder, M key, List<T> thing) {
        ((ListPlaceholder)placeholder).level.add(key, thing);
    }

    public void add(KeyListStorage<M, T> otherStorage) {
        this.levels.addAll(otherStorage.levels);
        this.placeholders.addAll(otherStorage.placeholders);
    }

    public boolean contains(M key) {
        for (Level level : this.levels) {
            if (!level.contains(key)) continue;
            return true;
        }
        return false;
    }

    public List<T> getValues(M key) {
        LinkedList result = new LinkedList();
        for (Level level : this.levels) {
            result.addAll(level.getValues(key));
        }
        return result;
    }

    public List<T> getAllValues() {
        LinkedList result = new LinkedList();
        for (Level level : this.levels) {
            result.addAll(level.getAllValues());
        }
        return result;
    }

    public ListPlaceholder<M, T> createPlaceholder() {
        Level<M, T> addLevel = this.addLevel();
        ListPlaceholder<M, T> placeholder = new ListPlaceholder<M, T>(addLevel);
        this.placeholders.add(placeholder);
        this.addLevel();
        return placeholder;
    }

    public void addDataToFirstPlaceholder(KeyListStorage<M, T> otherStorage) {
        ListPlaceholder<M, T> placeholder = this.placeholders.peekFirst();
        this.addDataOnly(placeholder, otherStorage);
    }

    private void addDataOnly(ListPlaceholder<M, T> placeholder, KeyListStorage<M, T> otherStorage) {
        for (Level level : otherStorage.levels) {
            ((ListPlaceholder)placeholder).level.addAll(level);
        }
    }

    public void closeFirstPlaceholder() {
        this.placeholders.pop();
    }

    public void replacePlaceholder(ListPlaceholder<M, T> placeholder, KeyListStorage<M, T> otherStorage) {
        ArraysUtils.replace(this.levels, ((ListPlaceholder)placeholder).level, otherStorage.levels);
        ArraysUtils.replace(this.placeholders, placeholder, otherStorage.placeholders);
    }

    private Level<M, T> getLastLevel() {
        if (this.levels.isEmpty()) {
            this.addLevel();
        }
        Level<M, T> lastLevel = this.levels.peekLast();
        return lastLevel;
    }

    private Level<M, T> addLevel() {
        this.levels.add(new Level());
        return this.levels.peekLast();
    }

    public KeyListStorage<M, T> clone() {
        try {
            KeyListStorage clone = (KeyListStorage)super.clone();
            clone.levels = ArraysUtils.deeplyClonedLinkedList(this.levels);
            clone.placeholders = new LinkedList();
            for (ListPlaceholder listPlaceholder : this.placeholders) {
                int index = this.levels.indexOf(listPlaceholder.level);
                Level<M, T> levelClone = clone.levels.get(index);
                clone.placeholders.add(new ListPlaceholder<M, T>(levelClone));
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Impossible state.");
        }
    }

    public static class ListPlaceholder<M, T> {
        private final Level<M, T> level;

        public ListPlaceholder(Level<M, T> level) {
            this.level = level;
        }
    }

    private static class Level<M, T>
    implements PubliclyCloneable {
        private Map<M, List<T>> storage = new HashMap<M, List<T>>();

        private Level() {
        }

        public void add(M key, T thing) {
            this.getStoredList(key).add(thing);
        }

        public void add(M key, List<T> things) {
            this.getStoredList(key).addAll(things);
        }

        public void addAll(Level<M, T> otherLevel) {
            for (Map.Entry<M, List<T>> entry : otherLevel.storage.entrySet()) {
                this.add(entry.getKey(), entry.getValue());
            }
        }

        private List<T> getStoredList(M key) {
            List<T> list = this.storage.get(key);
            if (list == null) {
                list = new ArrayList<T>();
                this.storage.put(key, list);
            }
            return list;
        }

        public boolean contains(M key) {
            return this.storage.containsKey(key);
        }

        public List<T> getValues(M key) {
            return this.storage.containsKey(key) ? this.storage.get(key) : new ArrayList();
        }

        public Collection<T> getAllValues() {
            ArrayList<T> result = new ArrayList<T>();
            for (List<T> list : this.storage.values()) {
                result.addAll(list);
            }
            return result;
        }

        @Override
        public Level<M, T> clone() {
            try {
                Level clone = (Level)super.clone();
                clone.storage = new HashMap<M, List<T>>(this.storage);
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new IllegalStateException("Impossible state.");
            }
        }
    }
}

