/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.stages;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.ReusableStructure;
import com.github.sommeri.less4j.core.compiler.expressions.ExpressionComparator;
import com.github.sommeri.less4j.core.compiler.expressions.PatternsComparator;
import com.github.sommeri.less4j.core.compiler.scopes.FoundMixin;
import com.github.sommeri.less4j.core.compiler.stages.EvaluatedMixinReferenceCall;
import java.util.ArrayList;
import java.util.List;

public class MixinsReferenceMatcher {
    private EvaluatedMixinReferenceCall evaluatedMixinReferenceParams;
    private ExpressionComparator comparator = new PatternsComparator();

    public MixinsReferenceMatcher(EvaluatedMixinReferenceCall evaluatedMixinReferenceParams) {
        this.evaluatedMixinReferenceParams = evaluatedMixinReferenceParams;
    }

    public List<FoundMixin> filterByParametersNumber(List<FoundMixin> mixins) {
        ArrayList<FoundMixin> result = new ArrayList<FoundMixin>();
        for (FoundMixin mixin : mixins) {
            if (!this.hasRightNumberOfParameters(mixin.getMixin())) continue;
            result.add(mixin);
        }
        return result;
    }

    public List<FoundMixin> filterByPatterns(List<FoundMixin> mixins) {
        ArrayList<FoundMixin> result = new ArrayList<FoundMixin>();
        for (FoundMixin mixin : mixins) {
            if (!this.patternsMatch(mixin.getMixin())) continue;
            result.add(mixin);
        }
        return result;
    }

    private boolean hasRightNumberOfParameters(ReusableStructure mixin) {
        int requiredNumber = this.evaluatedMixinReferenceParams.getNumberOfDeclaredParameters();
        int allDefined = mixin.getParameters().size();
        int mandatory = mixin.getMandatoryParameters().size();
        boolean hasRightNumberOfParameters = requiredNumber >= mandatory && (requiredNumber <= allDefined || mixin.hasCollectorParameter());
        return hasRightNumberOfParameters;
    }

    private boolean patternsMatch(ReusableStructure mixin) {
        int i = 0;
        for (ASTCssNode parameter : mixin.getParameters()) {
            if (parameter instanceof Expression) {
                if (!this.evaluatedMixinReferenceParams.hasPositionalParameter(i)) {
                    return false;
                }
                Expression pattern = (Expression)parameter;
                if (!this.comparator.equal(pattern, this.evaluatedMixinReferenceParams.getPositionalParameter(i))) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }
}

