/* $Id: JSONValueReader.java 1634297 2014-10-26 10:50:35Z kwright $ */

/**
* Licensed to the Apache Software Foundation (ASF) under one or more
* contributor license agreements. See the NOTICE file distributed with
* this work for additional information regarding copyright ownership.
* The ASF licenses this file to You under the Apache License, Version 2.0
* (the "License"); you may not use this file except in compliance with
* the License. You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
package org.apache.manifoldcf.connectorcommon.jsongen;

import java.io.*;

/** This class describes a JSON value reader, which can be any terminal value (e.g. string, integer, float). */
public class JSONValueReader extends JSONReader
{
  /** Wrapped reader */
  protected final Reader value;
  
  public JSONValueReader(Reader value)
  {
    this.value = value;
  }

  @Override
  public int read()
    throws IOException
  {
    return value.read();
  }
}


