/* $Id: NotificationConnectorPoolFactory.java 1647585 2014-12-23 14:46:43Z kwright $ */

/**
* Licensed to the Apache Software Foundation (ASF) under one or more
* contributor license agreements. See the NOTICE file distributed with
* this work for additional information regarding copyright ownership.
* The ASF licenses this file to You under the Apache License, Version 2.0
* (the "License"); you may not use this file except in compliance with
* the License. You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
package org.apache.manifoldcf.crawler.interfaces;

import org.apache.manifoldcf.core.interfaces.*;

import java.util.*;

/** Repository connector pool manager factory.
*/
public class NotificationConnectorPoolFactory
{
  public static final String _rcsid = "@(#)$Id: NotificationConnectorPoolFactory.java 1647585 2014-12-23 14:46:43Z kwright $";

  // name to use in thread context pool of objects
  private final static String objectName = "_NotificationConnectorPoolMgr_";

  private NotificationConnectorPoolFactory()
  {
  }

  /** Make a notification connector pool handle.
  *@param tc is the thread context.
  *@return the handle.
  */
  public static INotificationConnectorPool make(IThreadContext tc)
    throws ManifoldCFException
  {
    Object o = tc.get(objectName);
    if (o == null || !(o instanceof INotificationConnectorPool))
    {
      o = new org.apache.manifoldcf.crawler.notificationconnectorpool.NotificationConnectorPool(tc);
      tc.save(objectName,o);
    }
    return (INotificationConnectorPool)o;
  }

}
