/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.provider;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.ProviderException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.log4j.NDC;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.opensaml.BindingException;
import org.opensaml.SAMLConfig;
import org.opensaml.SAMLException;
import org.opensaml.SAMLObject;
import org.opensaml.SAMLRequest;
import org.opensaml.SAMLResponse;
import org.opensaml.SAMLSOAPHTTPBinding;
import org.opensaml.SOAPBinding;
import org.opensaml.SOAPException;
import org.opensaml.XML;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SOAPHTTPBindingProvider
extends SOAPBinding
implements SAMLSOAPHTTPBinding {
    private static SAMLConfig config = SAMLConfig.instance();
    private static SSLContext sslctx = null;
    private Logger log = Logger.getLogger((String)SOAPHTTPBindingProvider.class.getName());
    private Map httpHooks = Collections.synchronizedMap(new HashMap(4));

    public SOAPHTTPBindingProvider(String string, Element element) throws SAMLException {
        if (!string.equals("urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding")) {
            throw new SAMLException("SOAPHTTPBindingProvider does not support requested binding (" + string + ")");
        }
    }

    public void addHook(SAMLSOAPHTTPBinding.HTTPHook hTTPHook) {
        this.addHook(hTTPHook, null);
    }

    public void addHook(SAMLSOAPHTTPBinding.HTTPHook hTTPHook, Object object) {
        this.httpHooks.put(hTTPHook, object);
    }

    public SAMLResponse send(String string, SAMLRequest sAMLRequest, Object object) throws SAMLException {
        try {
            Object object2;
            Map.Entry entry;
            NDC.push((String)"send");
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Preparing to send the following SAML request to " + string + "\n" + sAMLRequest.toString()));
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Wrapping request to " + string + " in a SOAP envelope"));
            }
            Element element = this.sendRequest(sAMLRequest, object);
            this.log.debug((Object)("Setting connection properties for connecting to " + string));
            URLConnection uRLConnection = new URL(string).openConnection();
            uRLConnection.setAllowUserInteraction(false);
            uRLConnection.setDoOutput(true);
            ((HttpURLConnection)uRLConnection).setInstanceFollowRedirects(false);
            ((HttpURLConnection)uRLConnection).setRequestMethod("POST");
            ((HttpURLConnection)uRLConnection).setRequestProperty("Content-Type", "text/xml; charset=UTF-8");
            ((HttpURLConnection)uRLConnection).setRequestProperty("SOAPAction", "http://www.oasis-open.org/committees/security");
            if (uRLConnection instanceof HttpsURLConnection && sslctx != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Connection to " + string + " is an HTTPS connection, setting default SSL socket factory."));
                }
                ((HttpsURLConnection)uRLConnection).setSSLSocketFactory(sslctx.getSocketFactory());
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Connection to " + string + " set up, running " + this.httpHooks.size() + " outgoing client-side HTTP hooks."));
            }
            Canonicalizer canonicalizer = this.httpHooks.entrySet().iterator();
            while (canonicalizer.hasNext()) {
                entry = canonicalizer.next();
                if (((SAMLSOAPHTTPBinding.HTTPHook)entry.getKey()).outgoing((HttpURLConnection)uRLConnection, entry.getValue(), object)) continue;
                this.log.warn((Object)"HTTP processing hook returned false, aborting outgoing request");
                throw new BindingException(SAMLException.REQUESTER, "SOAPHTTPBindingProvider.send() HTTP processing hook returned false, aborted outgoing request");
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Connecting to " + string));
            }
            uRLConnection.connect();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Canonicalizing SOAP envelope-wrapped request and sending it to " + string));
            }
            canonicalizer = Canonicalizer.getInstance((String)"http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
            uRLConnection.getOutputStream().write(canonicalizer.canonicalizeSubtree((Node)element));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Message sent to " + string + ", running " + this.httpHooks.size() + " incoming client-side HTTP hooks."));
            }
            entry = this.httpHooks.entrySet().iterator();
            while (entry.hasNext()) {
                object2 = (Map.Entry)entry.next();
                if (((SAMLSOAPHTTPBinding.HTTPHook)object2.getKey()).incoming((HttpURLConnection)uRLConnection, object2.getValue(), object)) continue;
                this.log.warn((Object)"HTTP processing hook returned false, aborting incoming response");
                throw new BindingException("SOAPHTTPBindingProvider.send() HTTP processing hook returned false, aborted incoming response");
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Starting to process response from " + string));
            }
            entry = ((HttpURLConnection)uRLConnection).getContentType();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Response content type is " + (String)((Object)entry)));
            }
            if (entry == null || !((String)((Object)entry)).startsWith("text/xml")) {
                this.log.error((Object)("received an invalid content type in the response (" + (String)(entry != null ? entry : "none") + "), with the following content:"));
                object2 = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
                this.log.error((Object)((BufferedReader)object2).readLine());
                throw new BindingException("SOAPHTTPBindingProvider.send() detected an invalid content type (" + (String)(entry != null ? entry : "none") + ") in the response.");
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Unmarshalling response from " + string + " into a DOM document."));
            }
            element = XML.parserPool.parse(new InputSource(uRLConnection.getInputStream()), sAMLRequest.getMinorVersion() > 0 ? XML.parserPool.getSchemaSAML11() : XML.parserPool.getSchemaSAML10()).getDocumentElement();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Parsing and verifying SOAP response and retrieving SAML response from it.");
            }
            object2 = this.recvResponse(element, object);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Received the following SAML response as the response to the request to " + string + "\n" + ((SAMLObject)object2).toString()));
            }
            if (!((SAMLResponse)object2).getInResponseTo().equals(sAMLRequest.getId())) {
                this.log.error((Object)("Unable to match SAML InResponseTo value to request made to " + string));
                throw new BindingException("SOAPHTTPBindingProvider.send() unable to match SAML InResponseTo value to request");
            }
            Object object3 = object2;
            return object3;
        }
        catch (MalformedURLException malformedURLException) {
            throw new SAMLException("SAMLSOAPBinding.send() detected a malformed URL in the binding provided", (Exception)malformedURLException);
        }
        catch (SAXException sAXException) {
            throw new SAMLException("SAMLSOAPBinding.send() caught an XML exception while parsing the response", (Exception)sAXException);
        }
        catch (InvalidCanonicalizerException invalidCanonicalizerException) {
            throw new SAMLException("SAMLSOAPBinding.send() caught a C14N exception while serializing the request", (Exception)((Object)invalidCanonicalizerException));
        }
        catch (CanonicalizationException canonicalizationException) {
            throw new SAMLException("SAMLSOAPBinding.send() caught a C14N exception while serializing the request", (Exception)((Object)canonicalizationException));
        }
        catch (IOException iOException) {
            throw new SAMLException("SAMLSOAPBinding.send() caught an I/O exception", (Exception)iOException);
        }
        finally {
            NDC.pop();
        }
    }

    public SAMLRequest receive(Object object, Object object2, int n) throws SAMLException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)object;
        if (!httpServletRequest.getMethod().equals("POST") || !httpServletRequest.getContentType().startsWith("text/xml")) {
            throw new BindingException(SAMLException.REQUESTER, "SOAPHTTPBindingProvider.receive() found bad HTTP method or content type");
        }
        Iterator iterator = this.httpHooks.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (((SAMLSOAPHTTPBinding.HTTPHook)entry.getKey()).incoming(httpServletRequest, entry.getValue(), object2)) continue;
            this.log.warn((Object)"HTTP processing hook returned false, aborting incoming request");
            throw new BindingException(SAMLException.REQUESTER, "SOAPHTTPBindingProvider.recvRequest() HTTP processing hook returned false, aborted incoming request");
        }
        try {
            return this.recvRequest(XML.parserPool.parse(new InputSource((InputStream)httpServletRequest.getInputStream()), n > 0 ? XML.parserPool.getSchemaSAML11() : XML.parserPool.getSchemaSAML10()).getDocumentElement(), object2);
        }
        catch (SAXException sAXException) {
            throw new SOAPException(SOAPException.CLIENT, "SOAPHTTPBindingProvider.receive() detected an XML parsing error: " + sAXException.getMessage());
        }
        catch (IOException iOException) {
            throw new SOAPException(SOAPException.SERVER, "SOAPHTTPBindingProvider.receive() detected an I/O error: " + iOException.getMessage());
        }
    }

    public void respond(Object object, SAMLResponse sAMLResponse, SAMLException sAMLException, Object object2) throws SAMLException {
        HttpServletResponse httpServletResponse = (HttpServletResponse)object;
        try {
            Element element = this.sendResponse(sAMLResponse, sAMLException, object2);
            Canonicalizer canonicalizer = this.httpHooks.entrySet().iterator();
            while (canonicalizer.hasNext()) {
                Map.Entry entry = canonicalizer.next();
                if (((SAMLSOAPHTTPBinding.HTTPHook)entry.getKey()).outgoing(httpServletResponse, entry.getValue(), object2)) continue;
                this.log.warn((Object)"HTTP processing hook returned false, aborting outgoing response");
                throw new BindingException("SOAPHTTPBindingProvider.respond() HTTP processing hook returned false, aborted outgoing response");
            }
            canonicalizer = Canonicalizer.getInstance((String)"http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
            if (sAMLException != null) {
                httpServletResponse.setStatus(500);
            }
            httpServletResponse.setContentType("text/xml; charset=UTF-8");
            httpServletResponse.getOutputStream().write(canonicalizer.canonicalizeSubtree((Node)element));
        }
        catch (InvalidCanonicalizerException invalidCanonicalizerException) {
            invalidCanonicalizerException.printStackTrace();
            try {
                httpServletResponse.sendError(500, "SAMLSOAPBinding.respond() unable to serialize XML document instance");
            }
            catch (IOException iOException) {
                throw new SAMLException("SAMLSOAPBinding.respond() caught I/O exception while sending error response", (Exception)iOException);
            }
        }
        catch (CanonicalizationException canonicalizationException) {
            canonicalizationException.printStackTrace();
            try {
                httpServletResponse.sendError(500, "SAMLSOAPBinding.respond() unable to serialize XML document instance");
            }
            catch (IOException iOException) {
                throw new SAMLException("SAMLSOAPBinding.respond() caught I/O exception while sending error response", (Exception)iOException);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new SAMLException("SAMLSOAPBinding.respond() caught I/O exception while sending error response", (Exception)iOException);
        }
    }

    public SAMLResponse send(String string, SAMLRequest sAMLRequest) throws SAMLException {
        return this.send(string, sAMLRequest, null);
    }

    public SAMLRequest receive(Object object, int n) throws SAMLException {
        return this.receive(object, null, n);
    }

    public void respond(Object object, SAMLResponse sAMLResponse, SAMLException sAMLException) throws SAMLException {
        this.respond(object, sAMLResponse, sAMLException, null);
    }

    static {
        try {
            String string = config.getProperty("org.opensaml.ssl.keystore");
            String string2 = config.getProperty("org.opensaml.ssl.truststore");
            if (string != null || string2 != null) {
                Object object;
                String string3;
                String string4;
                KeyManagerFactory keyManagerFactory = null;
                TrustManagerFactory trustManagerFactory = null;
                if (string != null) {
                    string4 = config.getProperty("org.opensaml.ssl.keystore-pwd");
                    string3 = config.getProperty("org.opensaml.ssl.key-pwd");
                    object = config.getProperty("org.opensaml.ssl.keystore-type");
                    KeyStore keyStore = KeyStore.getInstance((String)(object != null ? object : "JKS"));
                    keyStore.load(new FileInputStream(string), string4 != null ? string4.toCharArray() : null);
                    keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
                    keyManagerFactory.init(keyStore, string3 != null ? string3.toCharArray() : null);
                }
                if (string2 != null) {
                    string4 = config.getProperty("org.opensaml.ssl.truststore-pwd");
                    string3 = config.getProperty("org.opensaml.ssl.truststore-type");
                    object = KeyStore.getInstance(string3 != null ? string3 : "JKS");
                    ((KeyStore)object).load(new FileInputStream(string2), string4 != null ? string4.toCharArray() : null);
                    trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
                    trustManagerFactory.init((KeyStore)object);
                }
                sslctx = SSLContext.getInstance("SSL");
                sslctx.init(keyManagerFactory != null ? keyManagerFactory.getKeyManagers() : null, trustManagerFactory != null ? trustManagerFactory.getTrustManagers() : null, null);
            }
        }
        catch (IOException iOException) {
            throw new ProviderException("SOAPHTTPBindingProvider caught I/O error initializing SSL context: " + iOException.getMessage());
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new ProviderException("SOAPHTTPBindingProvider caught security exception initializing SSL context: " + generalSecurityException.getMessage());
        }
    }
}

