/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.crs;

import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.crs.ParametricCRS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.cs.DefaultParametricCS;
import org.apache.sis.referencing.datum.DefaultParametricDatum;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.referencing.cs.CoordinateSystem;

@XmlType(name="ParametricCRSType", propOrder={"coordinateSystem", "datum"})
@XmlRootElement(name="ParametricCRS")
public class DefaultParametricCRS
extends AbstractCRS
implements ParametricCRS {
    private static final long serialVersionUID = 4013698133331342649L;
    private DefaultParametricDatum datum;

    public DefaultParametricCRS(Map<String, ?> map, DefaultParametricDatum defaultParametricDatum, DefaultParametricCS defaultParametricCS) {
        super(map, defaultParametricCS);
        ArgumentChecks.ensureNonNull("datum", defaultParametricDatum);
        this.datum = defaultParametricDatum;
    }

    protected DefaultParametricCRS(DefaultParametricCRS defaultParametricCRS) {
        super(defaultParametricCRS);
        this.datum = defaultParametricCRS.getDatum();
    }

    @Override
    @XmlElement(name="parametricDatum", required=true)
    public DefaultParametricDatum getDatum() {
        return this.datum;
    }

    @Override
    @XmlElement(name="parametricCS", required=true)
    public DefaultParametricCS getCoordinateSystem() {
        return (DefaultParametricCS)super.getCoordinateSystem();
    }

    @Override
    public DefaultParametricCRS forConvention(AxesConvention axesConvention) {
        return (DefaultParametricCRS)super.forConvention(axesConvention);
    }

    @Override
    final AbstractCRS createSameType(Map<String, ?> map, CoordinateSystem coordinateSystem) {
        return new DefaultParametricCRS(map, this.datum, (DefaultParametricCS)coordinateSystem);
    }

    @Override
    protected String formatTo(Formatter formatter) {
        super.formatTo(formatter);
        if (formatter.getConvention().majorVersion() == 1) {
            formatter.setInvalidWKT(this, null);
        }
        return DefaultParametricCRS.isBaseCRS(formatter) ? "BaseParamCRS" : "ParametricCRS";
    }

    private DefaultParametricCRS() {
    }

    private void setDatum(DefaultParametricDatum defaultParametricDatum) {
        if (this.datum == null) {
            this.datum = defaultParametricDatum;
        } else {
            MetadataUtilities.propertyAlreadySet(DefaultParametricCRS.class, "setDatum", "parametricDatum");
        }
    }

    private void setCoordinateSystem(DefaultParametricCS defaultParametricCS) {
        this.setCoordinateSystem("parametricCS", defaultParametricCS);
    }
}

