/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.BatchedRemoteIterator;
import org.apache.hadoop.fs.InvalidRequestException;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveEntry;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveInfo;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.ipc.RemoteException;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class CacheDirectiveIterator
extends BatchedRemoteIterator<Long, CacheDirectiveEntry> {
    private CacheDirectiveInfo filter;
    private final ClientProtocol namenode;

    public CacheDirectiveIterator(ClientProtocol namenode, CacheDirectiveInfo filter) {
        super((Object)0L);
        this.namenode = namenode;
        this.filter = filter;
    }

    private static CacheDirectiveInfo removeIdFromFilter(CacheDirectiveInfo filter) {
        CacheDirectiveInfo.Builder builder = new CacheDirectiveInfo.Builder(filter);
        builder.setId(null);
        return builder.build();
    }

    public BatchedRemoteIterator.BatchedEntries<CacheDirectiveEntry> makeRequest(Long prevKey) throws IOException {
        BatchedRemoteIterator.BatchedEntries<CacheDirectiveEntry> entries = null;
        try {
            entries = this.namenode.listCacheDirectives(prevKey, this.filter);
        }
        catch (IOException e) {
            if (e.getMessage().contains("Filtering by ID is unsupported")) {
                long id = this.filter.getId();
                this.filter = CacheDirectiveIterator.removeIdFromFilter(this.filter);
                entries = this.namenode.listCacheDirectives(id - 1L, this.filter);
                for (int i = 0; i < entries.size(); ++i) {
                    CacheDirectiveEntry entry = (CacheDirectiveEntry)entries.get(i);
                    if (!entry.getInfo().getId().equals(id)) continue;
                    return new SingleEntry(entry);
                }
                throw new RemoteException(InvalidRequestException.class.getName(), "Did not find requested id " + id);
            }
            throw e;
        }
        Preconditions.checkNotNull(entries);
        return entries;
    }

    public Long elementToPrevKey(CacheDirectiveEntry entry) {
        return entry.getInfo().getId();
    }

    private static class SingleEntry
    implements BatchedRemoteIterator.BatchedEntries<CacheDirectiveEntry> {
        private final CacheDirectiveEntry entry;

        public SingleEntry(CacheDirectiveEntry entry) {
            this.entry = entry;
        }

        public CacheDirectiveEntry get(int i) {
            if (i > 0) {
                return null;
            }
            return this.entry;
        }

        public int size() {
            return 1;
        }

        public boolean hasMore() {
            return false;
        }
    }
}

