/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.processor;

import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Vector;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.conversation.dkalgo.AlgoFactory;
import org.apache.ws.security.conversation.dkalgo.DerivationAlgorithm;
import org.apache.ws.security.message.token.DerivedKeyToken;
import org.apache.ws.security.message.token.Reference;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.processor.EncryptedKeyProcessor;
import org.apache.ws.security.processor.Processor;
import org.apache.ws.security.processor.SAMLTokenProcessor;
import org.apache.ws.security.processor.SecurityContextTokenProcessor;
import org.apache.ws.security.processor.UsernameTokenProcessor;
import org.apache.ws.security.saml.SAMLKeyInfo;
import org.apache.ws.security.saml.SAMLUtil;
import org.apache.ws.security.util.Base64;
import org.w3c.dom.Element;

public class DerivedKeyTokenProcessor
implements Processor {
    private String id;
    private byte[] keyBytes;
    private DerivedKeyToken dkt;
    private byte[] secret;
    private int length;
    private int offset;
    private byte[] nonce;
    private String label;
    private String algorithm;

    public void handleToken(Element elem, Crypto crypto, Crypto decCrypto, CallbackHandler cb, WSDocInfo wsDocInfo, Vector returnResults, WSSConfig config) throws WSSecurityException {
        this.dkt = new DerivedKeyToken(elem);
        this.extractSecret(wsDocInfo, this.dkt, cb, crypto);
        String tempNonce = this.dkt.getNonce();
        if (tempNonce == null) {
            throw new WSSecurityException("Missing wsc:Nonce value");
        }
        this.nonce = Base64.decode(tempNonce);
        this.length = this.dkt.getLength();
        this.label = this.dkt.getLabel();
        this.algorithm = this.dkt.getAlgorithm();
        this.id = this.dkt.getID();
        if (this.length > 0) {
            this.deriveKey();
            returnResults.add(0, new WSSecurityEngineResult(2048, this.secret, this.keyBytes, this.id, null));
        }
    }

    private void deriveKey() throws WSSecurityException {
        try {
            DerivationAlgorithm algo = AlgoFactory.getInstance(this.algorithm);
            byte[] labelBytes = null;
            labelBytes = this.label == null || this.label.length() == 0 ? "WS-SecureConversationWS-SecureConversation".getBytes("UTF-8") : this.label.getBytes("UTF-8");
            byte[] seed = new byte[labelBytes.length + this.nonce.length];
            System.arraycopy(labelBytes, 0, seed, 0, labelBytes.length);
            System.arraycopy(this.nonce, 0, seed, labelBytes.length, this.nonce.length);
            this.keyBytes = algo.createKey(this.secret, seed, this.offset, this.length);
        }
        catch (Exception e) {
            throw new WSSecurityException(0, null, null, e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void extractSecret(WSDocInfo wsDocInfo, DerivedKeyToken dkt, CallbackHandler cb, Crypto crypto) throws WSSecurityException {
        Processor processor;
        SecurityTokenReference str = dkt.getSecurityTokenReference();
        if (str == null) throw new WSSecurityException(6, "noReference");
        String uri = null;
        String keyIdentifierValueType = null;
        String keyIdentifierValue = null;
        if (str.containsReference()) {
            Reference ref = str.getReference();
            uri = ref.getURI();
            if (uri.charAt(0) == '#') {
                uri = uri.substring(1);
            }
            processor = wsDocInfo.getProcessor(uri);
        } else {
            keyIdentifierValue = str.getKeyIdentifierValue();
            keyIdentifierValueType = str.getKeyIdentifierValueType();
            processor = wsDocInfo.getProcessor(keyIdentifierValue);
        }
        if (processor == null && uri != null) {
            this.secret = this.getSecret(cb, uri);
            return;
        } else if (processor == null && keyIdentifierValue != null && keyIdentifierValueType != null) {
            X509Certificate[] certs = str.getKeyIdentifier(crypto);
            this.secret = certs == null || certs.length < 1 || certs[0] == null ? this.getSecret(cb, keyIdentifierValue, keyIdentifierValueType) : this.getSecret(cb, crypto, certs);
            return;
        } else if (processor instanceof UsernameTokenProcessor) {
            this.secret = ((UsernameTokenProcessor)processor).getDerivedKey(cb);
            return;
        } else if (processor instanceof EncryptedKeyProcessor) {
            this.secret = ((EncryptedKeyProcessor)processor).getDecryptedBytes();
            return;
        } else if (processor instanceof SecurityContextTokenProcessor) {
            this.secret = ((SecurityContextTokenProcessor)processor).getSecret();
            return;
        } else {
            if (!(processor instanceof SAMLTokenProcessor)) throw new WSSecurityException(6, "unsupportedKeyId");
            SAMLTokenProcessor samlp = (SAMLTokenProcessor)processor;
            SAMLKeyInfo keyInfo = SAMLUtil.getSAMLKeyInfo(samlp.getSamlTokenElement(), crypto, cb);
            this.secret = keyInfo.getSecret();
        }
    }

    private byte[] getSecret(CallbackHandler cb, String id) throws WSSecurityException {
        if (cb == null) {
            throw new WSSecurityException(0, "noCallback");
        }
        WSPasswordCallback callback = new WSPasswordCallback(id, 6);
        try {
            Callback[] callbacks = new Callback[]{callback};
            cb.handle(callbacks);
        }
        catch (IOException e) {
            throw new WSSecurityException(0, "noKey", new Object[]{id}, e);
        }
        catch (UnsupportedCallbackException e) {
            throw new WSSecurityException(0, "noKey", new Object[]{id}, e);
        }
        return callback.getKey();
    }

    private byte[] getSecret(CallbackHandler cb, String keyIdentifierValue, String keyIdentifierType) throws WSSecurityException {
        if (cb == null) {
            throw new WSSecurityException(0, "noCallback");
        }
        WSPasswordCallback pwcb = new WSPasswordCallback(keyIdentifierValue, null, keyIdentifierType, 8);
        try {
            Callback[] callbacks = new Callback[]{pwcb};
            cb.handle(callbacks);
        }
        catch (IOException e) {
            throw new WSSecurityException(0, "noKey", new Object[]{this.id}, e);
        }
        catch (UnsupportedCallbackException e) {
            throw new WSSecurityException(0, "noKey", new Object[]{this.id}, e);
        }
        return pwcb.getKey();
    }

    private byte[] getSecret(CallbackHandler cb, Crypto crypto, X509Certificate[] certs) throws WSSecurityException {
        if (cb == null) {
            throw new WSSecurityException(0, "noCallback");
        }
        String alias = crypto.getAliasForX509Cert(certs[0]);
        WSPasswordCallback pwCb = new WSPasswordCallback(alias, 1);
        try {
            Callback[] callbacks = new Callback[]{pwCb};
            cb.handle(callbacks);
        }
        catch (IOException e) {
            throw new WSSecurityException(0, "noPassword", new Object[]{alias}, e);
        }
        catch (UnsupportedCallbackException e) {
            throw new WSSecurityException(0, "noPassword", new Object[]{alias}, e);
        }
        String password = pwCb.getPassword();
        if (password == null) {
            throw new WSSecurityException(0, "noPassword", new Object[]{alias});
        }
        try {
            PrivateKey privateKey = crypto.getPrivateKey(alias, password);
            return privateKey.getEncoded();
        }
        catch (Exception e) {
            throw new WSSecurityException(6, null, null, e);
        }
    }

    public String getId() {
        return this.id;
    }

    public byte[] getKeyBytes() {
        return this.keyBytes;
    }

    public byte[] getKeyBytes(int len) throws WSSecurityException {
        this.length = len;
        this.deriveKey();
        return this.keyBytes;
    }

    public DerivedKeyToken getDerivedKeyToken() {
        return this.dkt;
    }
}

