/*
 * Decompiled with CFR 0.152.
 */
package org.itadaki.bzip2;

import java.io.IOException;
import org.itadaki.bzip2.BZip2BitOutputStream;
import org.itadaki.bzip2.BZip2DivSufSort;
import org.itadaki.bzip2.BZip2HuffmanStageEncoder;
import org.itadaki.bzip2.BZip2MTFAndRLE2StageEncoder;
import org.itadaki.bzip2.CRC32;

public class BZip2BlockCompressor {
    private final BZip2BitOutputStream bitOutputStream;
    private final CRC32 crc = new CRC32();
    private final byte[] block;
    private int blockLength = 0;
    private final int blockLengthLimit;
    private final boolean[] blockValuesPresent = new boolean[256];
    private final int[] bwtBlock;
    private int rleCurrentValue = -1;
    private int rleLength = 0;

    private void writeSymbolMap() throws IOException {
        int k;
        int j;
        int i;
        BZip2BitOutputStream bitOutputStream = this.bitOutputStream;
        boolean[] blockValuesPresent = this.blockValuesPresent;
        boolean[] condensedInUse = new boolean[16];
        for (i = 0; i < 16; ++i) {
            j = 0;
            k = i << 4;
            while (j < 16) {
                if (blockValuesPresent[k]) {
                    condensedInUse[i] = true;
                }
                ++j;
                ++k;
            }
        }
        for (i = 0; i < 16; ++i) {
            bitOutputStream.writeBoolean(condensedInUse[i]);
        }
        for (i = 0; i < 16; ++i) {
            if (!condensedInUse[i]) continue;
            j = 0;
            k = i * 16;
            while (j < 16) {
                bitOutputStream.writeBoolean(blockValuesPresent[k]);
                ++j;
                ++k;
            }
        }
    }

    private void writeRun(int value, int runLength) {
        int blockLength = this.blockLength;
        byte[] block = this.block;
        this.blockValuesPresent[value] = true;
        this.crc.updateCRC(value, runLength);
        byte byteValue = (byte)value;
        switch (runLength) {
            case 1: {
                block[blockLength] = byteValue;
                this.blockLength = blockLength + 1;
                break;
            }
            case 2: {
                block[blockLength] = byteValue;
                block[blockLength + 1] = byteValue;
                this.blockLength = blockLength + 2;
                break;
            }
            case 3: {
                block[blockLength] = byteValue;
                block[blockLength + 1] = byteValue;
                block[blockLength + 2] = byteValue;
                this.blockLength = blockLength + 3;
                break;
            }
            default: {
                this.blockValuesPresent[runLength -= 4] = true;
                block[blockLength] = byteValue;
                block[blockLength + 1] = byteValue;
                block[blockLength + 2] = byteValue;
                block[blockLength + 3] = byteValue;
                block[blockLength + 4] = (byte)runLength;
                this.blockLength = blockLength + 5;
            }
        }
    }

    public boolean write(int value) {
        if (this.blockLength > this.blockLengthLimit) {
            return false;
        }
        int rleCurrentValue = this.rleCurrentValue;
        int rleLength = this.rleLength;
        if (rleLength == 0) {
            this.rleCurrentValue = value;
            this.rleLength = 1;
        } else if (rleCurrentValue != value) {
            this.writeRun(rleCurrentValue & 0xFF, rleLength);
            this.rleCurrentValue = value;
            this.rleLength = 1;
        } else if (rleLength == 254) {
            this.writeRun(rleCurrentValue & 0xFF, 255);
            this.rleLength = 0;
        } else {
            this.rleLength = rleLength + 1;
        }
        return true;
    }

    public int write(byte[] data, int offset, int length) {
        int written = 0;
        while (length-- > 0 && this.write(data[offset++])) {
            ++written;
        }
        return written;
    }

    public void close() throws IOException {
        if (this.rleLength > 0) {
            this.writeRun(this.rleCurrentValue & 0xFF, this.rleLength);
        }
        this.block[this.blockLength] = this.block[0];
        BZip2DivSufSort divSufSort = new BZip2DivSufSort(this.block, this.bwtBlock, this.blockLength);
        int bwtStartPointer = divSufSort.bwt();
        this.bitOutputStream.writeBits(24, 3227993);
        this.bitOutputStream.writeBits(24, 2511705);
        this.bitOutputStream.writeInteger(this.crc.getCRC());
        this.bitOutputStream.writeBoolean(false);
        this.bitOutputStream.writeBits(24, bwtStartPointer);
        this.writeSymbolMap();
        BZip2MTFAndRLE2StageEncoder mtfEncoder = new BZip2MTFAndRLE2StageEncoder(this.bwtBlock, this.blockLength, this.blockValuesPresent);
        mtfEncoder.encode();
        BZip2HuffmanStageEncoder huffmanEncoder = new BZip2HuffmanStageEncoder(this.bitOutputStream, mtfEncoder.getMtfBlock(), mtfEncoder.getMtfLength(), mtfEncoder.getMtfAlphabetSize(), mtfEncoder.getMtfSymbolFrequencies());
        huffmanEncoder.encode();
    }

    public boolean isEmpty() {
        return this.blockLength == 0 && this.rleLength == 0;
    }

    public int getCRC() {
        return this.crc.getCRC();
    }

    public BZip2BlockCompressor(BZip2BitOutputStream bitOutputStream, int blockSize) {
        this.bitOutputStream = bitOutputStream;
        this.block = new byte[blockSize + 1];
        this.bwtBlock = new int[blockSize + 1];
        this.blockLengthLimit = blockSize - 6;
    }
}

