/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.commandline;

import com.github.sommeri.less4j.LessSource;
import com.github.sommeri.less4j.utils.ProblemsPrinter;
import com.github.sommeri.less4j.utils.URIUtils;
import java.io.File;

class RelativeFileSourceNamePrinter
implements ProblemsPrinter.SourceNamePrinter {
    private final File rootInputFile;

    public RelativeFileSourceNamePrinter(File rootInputFile) {
        this.rootInputFile = rootInputFile;
    }

    @Override
    public String printSourceName(LessSource source) {
        File absoluteFile;
        File file;
        if (source == null) {
            return "";
        }
        File file2 = file = source instanceof LessSource.FileSource ? ((LessSource.FileSource)source).getInputFile() : null;
        if (file == null) {
            String name = source.getName();
            return name == null ? "" : name;
        }
        if (this.rootInputFile == null) {
            return file.getPath();
        }
        File absoluteRoot = this.rootInputFile.getAbsoluteFile();
        if (this.sameFile(absoluteRoot, absoluteFile = file.getAbsoluteFile())) {
            return "";
        }
        return URIUtils.relativize(absoluteRoot.getParentFile(), absoluteFile);
    }

    private boolean sameFile(File file1, File file2) {
        String fileAbsoluteName = file2.getAbsolutePath();
        String rootInputFileAbsoluteName = file1.getAbsolutePath();
        boolean equals = fileAbsoluteName.equals(rootInputFileAbsoluteName);
        return equals;
    }
}

