/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.expressions;

import com.github.sommeri.less4j.core.ast.ColorExpression;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.NumberExpression;
import com.github.sommeri.less4j.core.compiler.expressions.AbstractColorAmountFunction;
import com.github.sommeri.less4j.core.compiler.expressions.HSLAValue;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;

class Spin
extends AbstractColorAmountFunction {
    public Spin() {
        super(false);
    }

    @Override
    protected Expression evaluate(ColorExpression color, NumberExpression amount, boolean isAbsolute, HiddenTokenAwareTree token) {
        HSLAValue hsla = Spin.toHSLA(color);
        this.apply(amount, hsla);
        return Spin.hsla(hsla, token);
    }

    protected void apply(NumberExpression amount, HSLAValue hsla) {
        double hue = (hsla.h + amount.getValueAsDouble()) % 360.0;
        hsla.h = hue < 0.0 ? 360.0 + hue : hue;
    }

    @Override
    protected String getName() {
        return "spin";
    }
}

