/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.client.marshaller;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionLikeType;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.nuxeo.client.marshaller.NuxeoRequestConverterFactory;
import org.nuxeo.client.marshaller.NuxeoResponseConverterFactory;
import org.nuxeo.client.spi.NuxeoClientException;
import retrofit2.Converter;
import retrofit2.Retrofit;

public class NuxeoConverterFactory
extends Converter.Factory {
    protected static final Map<String, Class<?>> entityTypeToClass = new HashMap();
    protected final ObjectMapper mapper;

    protected NuxeoConverterFactory(ObjectMapper mapper) {
        this.mapper = Objects.requireNonNull(mapper, "mapper == null");
    }

    public static NuxeoConverterFactory create() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return NuxeoConverterFactory.create(mapper);
    }

    public static NuxeoConverterFactory create(ObjectMapper mapper) {
        return new NuxeoConverterFactory(mapper);
    }

    public static void registerEntity(String entityType, Class<?> clazz) {
        entityTypeToClass.put(entityType, clazz);
    }

    public Converter<ResponseBody, ?> responseBodyConverter(Type type, Annotation[] annotations, Retrofit client) {
        JavaType javaType = this.mapper.getTypeFactory().constructType(type);
        return new NuxeoResponseConverterFactory(this.mapper, javaType, entityTypeToClass);
    }

    public Converter<?, RequestBody> requestBodyConverter(Type type, Annotation[] parameterAnnotations, Annotation[] methodAnnotations, Retrofit retrofit) {
        JavaType javaType = this.mapper.getTypeFactory().constructType(type);
        return new NuxeoRequestConverterFactory(this.mapper, javaType);
    }

    public <T> T readJSON(String json, Class<T> javaType) {
        try {
            return (T)this.mapper.readValue(json, javaType);
        }
        catch (IOException reason) {
            throw new NuxeoClientException("Converter Read Issue. See NuxeoConverterFactory#readJSON", reason);
        }
    }

    public <T> T readJSON(String json, Class javaTypeContainer, Class javaType) {
        try {
            CollectionLikeType type = this.mapper.getTypeFactory().constructCollectionLikeType(javaTypeContainer, javaType);
            return (T)this.mapper.readValue(json, (JavaType)type);
        }
        catch (IOException reason) {
            throw new NuxeoClientException("Converter Read Issue.", reason);
        }
    }

    public String writeJSON(Object object) {
        try {
            return this.mapper.writeValueAsString(object);
        }
        catch (IOException reason) {
            throw new NuxeoClientException("Converter Write Issue. See NuxeoConverterFactory#writeJSON", reason);
        }
    }
}

