/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.client.objects;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;
import org.nuxeo.client.NuxeoClient;
import org.nuxeo.client.objects.AbstractBase;
import org.nuxeo.client.objects.Connectable;
import retrofit2.Call;
import retrofit2.Callback;

public class AbstractConnectable<A, B extends AbstractConnectable<A, B>>
extends AbstractBase<B>
implements Connectable {
    @JsonIgnore
    protected final Class<A> apiClass;
    @JsonIgnore
    protected NuxeoClient nuxeoClient;
    @JsonIgnore
    protected A api;

    protected AbstractConnectable(Class<A> apiClass) {
        this.apiClass = Objects.requireNonNull(apiClass, "API interface must be provided");
    }

    protected AbstractConnectable(Class<A> apiClass, NuxeoClient nuxeoClient) {
        super(nuxeoClient);
        this.apiClass = Objects.requireNonNull(apiClass, "API interface must be provided");
        this.nuxeoClient = nuxeoClient;
        this.api = this.retrofit.create(apiClass);
    }

    protected <T> T fetchResponse(Call<T> call) {
        return this.nuxeoClient.fetchResponse(call);
    }

    protected <T> void fetchResponse(Call<T> call, Callback<T> callback) {
        this.nuxeoClient.fetchResponse(call, callback);
    }

    @Override
    public void reconnectWith(NuxeoClient nuxeoClient) {
        this.replaceWith(nuxeoClient);
        this.nuxeoClient = nuxeoClient;
        this.api = this.retrofit.create(this.apiClass);
    }

    @Override
    protected void buildRetrofit() {
        super.buildRetrofit();
        this.api = this.retrofit.create(this.apiClass);
    }
}

